/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.desair.tus.server.upload.UploadId;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class UploadIdFactory {
    private String uploadURI = "/";
    private Pattern uploadUriPattern = null;

    public void setUploadURI(String uploadURI) {
        Validate.notBlank((CharSequence)uploadURI, (String)"The upload URI pattern cannot be blank", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.startsWith((CharSequence)uploadURI, (CharSequence)"/"), (String)"The upload URI should start with /", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.endsWith((CharSequence)uploadURI, (CharSequence)"$") ? 1 : 0) != 0, (String)"The upload URI should not end with $", (Object[])new Object[0]);
        this.uploadURI = uploadURI;
        this.uploadUriPattern = null;
    }

    public String getUploadURI() {
        return this.uploadURI;
    }

    public UploadId readUploadId(String url) {
        Matcher uploadUriMatcher = this.getUploadUriPattern().matcher(StringUtils.trimToEmpty((String)url));
        String pathId = uploadUriMatcher.replaceFirst("");
        Serializable idValue = null;
        if (StringUtils.isNotBlank((CharSequence)pathId)) {
            idValue = this.getIdValueIfValid(pathId);
        }
        return idValue == null ? null : new UploadId(idValue);
    }

    public abstract UploadId createId();

    protected abstract Serializable getIdValueIfValid(String var1);

    protected Pattern getUploadUriPattern() {
        if (this.uploadUriPattern == null) {
            this.uploadUriPattern = Pattern.compile("^.*" + this.uploadURI + (StringUtils.endsWith((CharSequence)this.uploadURI, (CharSequence)"/") ? "" : "/?"));
        }
        return this.uploadUriPattern;
    }
}

