/*
 * Decompiled with CFR 0.152.
 */
package me.paulschwarz.springdotenv;

import java.util.Objects;
import java.util.Optional;
import org.springframework.core.env.ConfigurableEnvironment;

public class DotenvConfig {
    private static final String CONFIG_PREFIX = ".env.";
    private String directory;
    private String filename;
    private Boolean ignoreIfMalformed;
    private Boolean ignoreIfMissing = true;
    private Boolean systemProperties;
    private String prefix;

    public DotenvConfig(ConfigurableEnvironment environment) {
        this.directory = this.getEnvironmentProperty(environment, "directory", this.directory);
        this.filename = this.getEnvironmentProperty(environment, "filename", this.filename);
        this.ignoreIfMalformed = this.getEnvironmentProperty(environment, "ignoreIfMalformed", this.ignoreIfMalformed);
        this.ignoreIfMissing = this.getEnvironmentProperty(environment, "ignoreIfMissing", this.ignoreIfMissing);
        this.systemProperties = this.getEnvironmentProperty(environment, "systemProperties", this.systemProperties);
        this.prefix = this.getEnvironmentProperty(environment, "prefix", this.prefix);
    }

    private String getEnvironmentProperty(ConfigurableEnvironment environment, String key, String defaultValue) {
        if (Objects.isNull(environment)) {
            return defaultValue;
        }
        return environment.getProperty(CONFIG_PREFIX + key, defaultValue);
    }

    private boolean getEnvironmentProperty(ConfigurableEnvironment environment, String key, Boolean defaultValue) {
        String defaultValueAsString = String.valueOf(defaultValue != null && defaultValue != false);
        String valueAsString = this.getEnvironmentProperty(environment, key, defaultValueAsString);
        return Boolean.parseBoolean(valueAsString);
    }

    public Optional<String> getDirectoryOptional() {
        return Optional.ofNullable(this.directory);
    }

    public Optional<String> getFilenameOptional() {
        return Optional.ofNullable(this.filename);
    }

    public Optional<String> getPrefixOptional() {
        return Optional.ofNullable(this.prefix);
    }

    public Optional<Boolean> getIgnoreIfMalformedTruth() {
        return Optional.ofNullable(this.ignoreIfMalformed).filter(Boolean::booleanValue);
    }

    public Optional<Boolean> getIgnoreIfMissingTruth() {
        return Optional.ofNullable(this.ignoreIfMissing).filter(Boolean::booleanValue);
    }

    public Optional<Boolean> getSystemPropertiesTruth() {
        return Optional.ofNullable(this.systemProperties).filter(Boolean::booleanValue);
    }

    public String toString() {
        return "DotenvConfig{directory=" + this.getDirectoryOptional().map(value -> "'" + value + "'").orElse("null") + ", filename=" + this.getFilenameOptional().map(value -> "'" + value + "'").orElse("null") + ", ignoreIfMalformed=" + this.ignoreIfMalformed + ", ignoreIfMissing=" + this.ignoreIfMissing + ", systemProperties=" + this.systemProperties + ", prefix=" + this.prefix + '}';
    }
}

