/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.autoconfigure;

import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import javax.transaction.TransactionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;

public class NarayanaBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private static final String[] NO_BEANS = new String[0];
    private static final int ORDER = Integer.MAX_VALUE;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] transactionManagers = beanFactory.getBeanNamesForType(TransactionManager.class, true, false);
        String[] recoveryManagerServices = beanFactory.getBeanNamesForType(RecoveryManagerService.class, true, false);
        this.addBeanDependencies(beanFactory, transactionManagers, "javax.sql.DataSource");
        this.addBeanDependencies(beanFactory, recoveryManagerServices, "javax.sql.DataSource");
        this.addBeanDependencies(beanFactory, transactionManagers, "javax.jms.ConnectionFactory");
        this.addBeanDependencies(beanFactory, recoveryManagerServices, "javax.jms.ConnectionFactory");
    }

    private void addBeanDependencies(ConfigurableListableBeanFactory beanFactory, String[] beanNames, String dependencyType) {
        for (String beanName : beanNames) {
            this.addBeanDependencies(beanFactory, beanName, dependencyType);
        }
    }

    private void addBeanDependencies(ConfigurableListableBeanFactory beanFactory, String beanName, String dependencyType) {
        for (String dependentBeanName : this.getBeanNamesForType(beanFactory, dependencyType)) {
            beanFactory.registerDependentBean(beanName, dependentBeanName);
        }
    }

    private String[] getBeanNamesForType(ConfigurableListableBeanFactory beanFactory, String type) {
        try {
            return beanFactory.getBeanNamesForType(Class.forName(type), true, false);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return NO_BEANS;
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

