/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import me.tongfei.progressbar.ProgressBarConsumer;
import me.tongfei.progressbar.ProgressBarRenderer;
import me.tongfei.progressbar.ProgressState;

class ProgressThread
implements Runnable {
    private ProgressState progress;
    private ProgressBarRenderer renderer;
    private long updateInterval;
    private ProgressBarConsumer consumer;

    ProgressThread(ProgressState progress, ProgressBarRenderer renderer, long updateInterval, ProgressBarConsumer consumer) {
        this.progress = progress;
        this.renderer = renderer;
        this.updateInterval = updateInterval;
        this.consumer = consumer;
    }

    private void refresh() {
        String rendered = this.renderer.render(this.progress, this.consumer.getMaxProgressLength());
        this.consumer.accept(rendered);
    }

    void closeConsumer() {
        this.consumer.close();
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.refresh();
                Thread.sleep(this.updateInterval);
            }
        }
        catch (InterruptedException ignored) {
            this.refresh();
        }
    }
}

