/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.List;
import net.bull.javamelody.CacheInformations;
import net.bull.javamelody.HtmlAbstractReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.Parameters;

class HtmlCacheInformationsReport
extends HtmlAbstractReport {
    private final List<CacheInformations> cacheInformationsList;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final boolean hitsRatioEnabled;
    private final boolean configurationEnabled;
    private final boolean systemActionsEnabled = Parameters.isSystemActionsEnabled();

    HtmlCacheInformationsReport(List<CacheInformations> cacheInformationsList, Writer writer) {
        super(writer);
        assert (cacheInformationsList != null);
        this.cacheInformationsList = cacheInformationsList;
        this.hitsRatioEnabled = HtmlCacheInformationsReport.isHitsRatioEnabled(cacheInformationsList);
        this.configurationEnabled = HtmlCacheInformationsReport.isConfigurationEnabled(cacheInformationsList);
    }

    @Override
    void toHtml() throws IOException {
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlCacheInformationsReport.getString("Caches"));
        this.write("<th>#Cache#</th>");
        if (this.configurationEnabled) {
            this.write("<th class='sorttable_numeric'>#Pourcentage_memoire_utilise#</th>");
        }
        this.write("<th class='sorttable_numeric'>#Nb_objets_en_memoire#</th>");
        this.write("<th class='sorttable_numeric'>#Nb_objets_sur_disque#</th>");
        if (this.hitsRatioEnabled) {
            this.write("<th class='sorttable_numeric'>");
            this.write(HtmlCacheInformationsReport.getString("Efficacite_cache_memoire").replaceAll("\n", "<br/>"));
            this.write("</th><th class='sorttable_numeric'>");
            this.write(HtmlCacheInformationsReport.getString("Efficacite_cache").replaceAll("\n", "<br/>"));
            this.write("</th>");
        }
        if (this.configurationEnabled) {
            this.write("<th>#Configuration#</th>");
        }
        if (this.systemActionsEnabled) {
            this.write("<th class='noPrint'>#Purger#</th>");
        }
        for (CacheInformations cacheInformations : this.cacheInformationsList) {
            table.nextRow();
            this.writeCacheInformations(cacheInformations);
        }
        table.endTable();
        this.write("<div align='right' class='noPrint'>");
        if (!this.hitsRatioEnabled) {
            this.writeln("#caches_statistics_enable#<br/>");
        }
        if (this.systemActionsEnabled) {
            this.writeln("<a href='?action=clear_caches' onclick=\"javascript:return confirm('" + HtmlCacheInformationsReport.getStringForJavascript("confirm_purge_caches") + "');\">");
            this.writeln("<img src='?resource=user-trash.png' width='18' height='18' alt=\"#Purge_caches#\" /> #Purge_caches#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        this.writeDirectly("<a href='http://ehcache.sourceforge.net/apidocs/net/sf/ehcache/config/CacheConfiguration.html#field_summary'");
        this.writeln("target='_blank'>Configuration reference</a></div>");
    }

    private void writeCacheInformations(CacheInformations cacheInformations) throws IOException {
        this.write("<td>");
        this.writeDirectly(HtmlCacheInformationsReport.htmlEncodeButNotSpace(cacheInformations.getName()));
        String nextColumnAlignRight = "</td> <td align='right'>";
        if (this.configurationEnabled) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(cacheInformations.getInMemoryPercentUsed()));
        }
        this.write("</td> <td align='right'>");
        this.write(this.integerFormat.format(cacheInformations.getInMemoryObjectCount()));
        this.write("</td> <td align='right'>");
        this.write(this.integerFormat.format(cacheInformations.getOnDiskObjectCount()));
        if (this.hitsRatioEnabled) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(cacheInformations.getInMemoryHitsRatio()));
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(cacheInformations.getHitsRatio()));
        }
        if (this.configurationEnabled) {
            this.write("</td> <td>");
            this.write(cacheInformations.getConfiguration());
        }
        this.write("</td>");
        if (this.systemActionsEnabled) {
            this.write("<td align='center' class='noPrint'>");
            String confirmClearCache = HtmlCacheInformationsReport.javascriptEncode(HtmlCacheInformationsReport.getFormattedString("confirm_purge_cache", cacheInformations.getName()));
            this.writeDirectly("<a href='?action=clear_cache&amp;cacheId=" + HtmlCacheInformationsReport.urlEncode(cacheInformations.getName()) + "' onclick=\"javascript:return confirm('" + confirmClearCache + "');\">");
            String title = HtmlCacheInformationsReport.htmlEncode(HtmlCacheInformationsReport.getFormattedString("Purge_cache", cacheInformations.getName()));
            this.writeDirectly("<img src='?resource=user-trash.png' width='16' height='16' alt='" + title + "' title='" + title + "' /></a>");
            this.write("</td>");
        }
    }

    static boolean isHitsRatioEnabled(List<CacheInformations> cacheInformationsList) {
        for (CacheInformations cacheInformations : cacheInformationsList) {
            if (cacheInformations.getHitsRatio() < 0 && cacheInformations.getInMemoryHitsRatio() < 0) continue;
            return true;
        }
        return false;
    }

    static boolean isConfigurationEnabled(List<CacheInformations> cacheInformationsList) {
        for (CacheInformations cacheInformations : cacheInformationsList) {
            if (cacheInformations.getConfiguration() == null) continue;
            return true;
        }
        return false;
    }
}

