/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.bytebuddy.utility.ByteBuddyCommons;
import net.bytebuddy.utility.StreamDrainer;

public interface ClassFileLocator {
    public static final String CLASS_FILE_EXTENSION = ".class";

    public Resolution locate(String var1) throws IOException;

    public static class Compound
    implements ClassFileLocator {
        private final ClassFileLocator[] classFileLocator;

        public Compound(ClassFileLocator ... classFileLocator) {
            this.classFileLocator = classFileLocator;
        }

        @Override
        public Resolution locate(String typeName) throws IOException {
            for (ClassFileLocator classFileLocator : this.classFileLocator) {
                Resolution resolution = classFileLocator.locate(typeName);
                if (!resolution.isResolved()) continue;
                return resolution;
            }
            return Resolution.Illegal.INSTANCE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.classFileLocator, ((Compound)other).classFileLocator);
        }

        public int hashCode() {
            return Arrays.hashCode(this.classFileLocator);
        }

        public String toString() {
            return "ClassFileLocator.Compound{classFileLocator=" + Arrays.toString(this.classFileLocator) + '}';
        }
    }

    public static class AgentBased
    implements ClassFileLocator {
        private static final String BYTE_BUDDY_AGENT_TYPE = "net.bytebuddy.agent.ByteBuddyAgent";
        private static final String GET_INSTRUMENTATION_METHOD = "getInstrumentation";
        private static final Object STATIC_METHOD = null;
        private final Instrumentation instrumentation;
        private final ClassLoadingDelegate classLoadingDelegate;

        public AgentBased(Instrumentation instrumentation, ClassLoader classLoader) {
            this(instrumentation, ClassLoadingDelegate.Default.of(classLoader));
        }

        public AgentBased(Instrumentation instrumentation, ClassLoadingDelegate classLoadingDelegate) {
            if (!instrumentation.isRetransformClassesSupported()) {
                throw new IllegalArgumentException(instrumentation + " does not support retransformation");
            }
            this.instrumentation = instrumentation;
            this.classLoadingDelegate = ByteBuddyCommons.nonNull(classLoadingDelegate);
        }

        public static ClassFileLocator fromInstalledAgent(ClassLoader classLoader) {
            try {
                return new AgentBased((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(BYTE_BUDDY_AGENT_TYPE).getDeclaredMethod(GET_INSTRUMENTATION_METHOD, new Class[0]).invoke(STATIC_METHOD, new Object[0]), classLoader);
            }
            catch (Exception e) {
                throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) {
            Resolution resolution;
            ExtractionClassFileTransformer classFileTransformer = new ExtractionClassFileTransformer(this.classLoadingDelegate.getClassLoader(), typeName);
            try {
                this.instrumentation.addTransformer(classFileTransformer, true);
                this.instrumentation.retransformClasses(this.classLoadingDelegate.locate(typeName));
                byte[] binaryRepresentation = classFileTransformer.getBinaryRepresentation();
                resolution = binaryRepresentation == null ? Resolution.Illegal.INSTANCE : new Resolution.Explicit(binaryRepresentation);
                this.instrumentation.removeTransformer(classFileTransformer);
            }
            catch (Throwable throwable) {
                try {
                    this.instrumentation.removeTransformer(classFileTransformer);
                    throw throwable;
                }
                catch (Exception ignored) {
                    return Resolution.Illegal.INSTANCE;
                }
            }
            return resolution;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classLoadingDelegate.equals(((AgentBased)other).classLoadingDelegate) && this.instrumentation.equals(((AgentBased)other).instrumentation);
        }

        public int hashCode() {
            return 31 * this.instrumentation.hashCode() + this.classLoadingDelegate.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.AgentBased{instrumentation=" + this.instrumentation + ", classLoadingDelegate=" + this.classLoadingDelegate + '}';
        }

        protected static class ExtractionClassFileTransformer
        implements ClassFileTransformer {
            private static final byte[] DO_NOT_TRANSFORM = null;
            private final ClassLoader classLoader;
            private final String typeName;
            private volatile byte[] binaryRepresentation;

            protected ExtractionClassFileTransformer(ClassLoader classLoader, String typeName) {
                this.classLoader = classLoader;
                this.typeName = typeName;
            }

            @Override
            public byte[] transform(ClassLoader classLoader, String internalName, Class<?> redefinedType, ProtectionDomain protectionDomain, byte[] classFile) throws IllegalClassFormatException {
                if (this.isChild(classLoader) && this.typeName.equals(redefinedType.getName())) {
                    this.binaryRepresentation = classFile;
                }
                return DO_NOT_TRANSFORM;
            }

            private boolean isChild(ClassLoader classLoader) {
                if (this.classLoader == null) {
                    return true;
                }
                do {
                    if (classLoader != this.classLoader) continue;
                    return true;
                } while ((classLoader = classLoader.getParent()) != null);
                return false;
            }

            protected byte[] getBinaryRepresentation() {
                return this.binaryRepresentation;
            }

            public String toString() {
                return "ClassFileLocator.AgentBased.ExtractionClassFileTransformer{classLoader=" + this.classLoader + ", typeName=" + this.typeName + ", binaryRepresentation=" + (this.binaryRepresentation != null ? "<" + this.binaryRepresentation.length + " bytes>" : "null") + '}';
            }
        }

        public static interface ClassLoadingDelegate {
            public Class<?> locate(String var1) throws ClassNotFoundException;

            public ClassLoader getClassLoader();

            public static class Explicit
            implements ClassLoadingDelegate {
                private final ClassLoadingDelegate fallbackDelegate;
                private final Map<String, Class<?>> types;

                public Explicit(ClassLoader classLoader, Collection<Class<?>> types) {
                    this(new Default(classLoader), types);
                }

                public Explicit(ClassLoadingDelegate fallbackDelegate, Collection<Class<?>> types) {
                    this.fallbackDelegate = fallbackDelegate;
                    this.types = new HashMap(types.size());
                    for (Class<?> type : types) {
                        this.types.put(type.getName(), type);
                    }
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    Class<?> type = this.types.get(name);
                    return type == null ? this.fallbackDelegate.locate(name) : type;
                }

                @Override
                public ClassLoader getClassLoader() {
                    return this.fallbackDelegate.getClassLoader();
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fallbackDelegate.equals(((Explicit)other).fallbackDelegate) && this.types.equals(((Explicit)other).types);
                }

                public int hashCode() {
                    int result = this.fallbackDelegate.hashCode();
                    result = 31 * result + this.types.hashCode();
                    return result;
                }

                public String toString() {
                    return "ClassFileLocator.AgentBased.ClassLoadingDelegate.Explicit{fallbackDelegate=" + this.fallbackDelegate + ", types=" + this.types + '}';
                }
            }

            public static class ForDelegatingClassLoader
            extends Default {
                private static final String DELEGATING_CLASS_LOADER_NAME = "sun.reflect.DelegatingClassLoader";
                private static final int ONLY = 0;
                private static final JavaField CLASSES_FIELD;

                protected ForDelegatingClassLoader(ClassLoader classLoader) {
                    super(classLoader);
                }

                protected static boolean isDelegating(ClassLoader classLoader) {
                    return classLoader != null && classLoader.getClass().getName().equals(DELEGATING_CLASS_LOADER_NAME);
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    Vector classes;
                    try {
                        classes = (Vector)CLASSES_FIELD.readValue(this.classLoader);
                    }
                    catch (Exception ignored) {
                        return super.locate(name);
                    }
                    if (classes.size() != 1) {
                        return super.locate(name);
                    }
                    Class<?> type = (Class<?>)classes.get(0);
                    return type.getName().equals(name) ? type : super.locate(name);
                }

                @Override
                public String toString() {
                    return "ClassFileLocator.AgentBased.ClassLoadingDelegate.ForDelegatingClassLoader{classLoader=" + this.classLoader + '}';
                }

                static {
                    JavaField classesField;
                    try {
                        Field field = ClassLoader.class.getDeclaredField("classes");
                        field.setAccessible(true);
                        classesField = new JavaField.ForResolvedField(field);
                    }
                    catch (Exception e) {
                        classesField = new JavaField.ForNonResolvedField(e);
                    }
                    CLASSES_FIELD = classesField;
                }

                protected static interface JavaField {
                    public Object readValue(Object var1) throws Exception;

                    public static class ForNonResolvedField
                    implements JavaField {
                        private final Exception exception;

                        public ForNonResolvedField(Exception exception) {
                            this.exception = exception;
                        }

                        @Override
                        public Object readValue(Object instance) throws Exception {
                            throw this.exception;
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.exception.equals(((ForNonResolvedField)other).exception);
                        }

                        public int hashCode() {
                            return this.exception.hashCode();
                        }

                        public String toString() {
                            return "ClassFileLocator.AgentBased.ClassLoadingDelegate.ForDelegatingClassLoader.JavaField.ForNonResolvedField{exception=" + this.exception + '}';
                        }
                    }

                    public static class ForResolvedField
                    implements JavaField {
                        private final Field field;

                        public ForResolvedField(Field field) {
                            this.field = field;
                        }

                        @Override
                        public Object readValue(Object instance) throws Exception {
                            return this.field.get(instance);
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.field.equals(((ForResolvedField)other).field);
                        }

                        public int hashCode() {
                            return this.field.hashCode();
                        }

                        public String toString() {
                            return "ClassFileLocator.AgentBased.ClassLoadingDelegate.ForDelegatingClassLoader.JavaField.ForResolvedField{field=" + this.field + '}';
                        }
                    }
                }
            }

            public static class Default
            implements ClassLoadingDelegate {
                protected final ClassLoader classLoader;

                protected Default(ClassLoader classLoader) {
                    this.classLoader = classLoader;
                }

                public static ClassLoadingDelegate of(ClassLoader classLoader) {
                    return ForDelegatingClassLoader.isDelegating(classLoader) ? new ForDelegatingClassLoader(classLoader) : new Default(classLoader);
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    return this.classLoader.loadClass(name);
                }

                @Override
                public ClassLoader getClassLoader() {
                    return this.classLoader;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Default aDefault = (Default)other;
                    return !(this.classLoader == null ? aDefault.classLoader != null : !this.classLoader.equals(aDefault.classLoader));
                }

                public int hashCode() {
                    return this.classLoader != null ? this.classLoader.hashCode() : 0;
                }

                public String toString() {
                    return "ClassFileLocator.AgentBased.ClassLoadingDelegate.Default{classLoader=" + this.classLoader + '}';
                }
            }
        }
    }

    public static class ForClassLoader
    implements ClassFileLocator {
        private final ClassLoader classLoader;

        protected ForClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public static ClassFileLocator ofClassPath() {
            return new ForClassLoader(ClassLoader.getSystemClassLoader());
        }

        public static ClassFileLocator of(ClassLoader classLoader) {
            return new ForClassLoader(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) throws IOException {
            InputStream inputStream = this.classLoader.getResourceAsStream(typeName.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (inputStream != null) {
                try {
                    Resolution.Explicit explicit = new Resolution.Explicit(new StreamDrainer().drain(inputStream));
                    return explicit;
                }
                finally {
                    inputStream.close();
                }
            }
            return Resolution.Illegal.INSTANCE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classLoader.equals(((ForClassLoader)other).classLoader);
        }

        public int hashCode() {
            return this.classLoader.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.ForClassLoader{classLoader=" + this.classLoader + '}';
        }
    }

    public static interface Resolution {
        public boolean isResolved();

        public byte[] resolve();

        public static class Explicit
        implements Resolution {
            private final byte[] binaryRepresentation;

            public Explicit(byte[] binaryRepresentation) {
                this.binaryRepresentation = binaryRepresentation;
            }

            public static Resolution of(Class<?> type) {
                InputStream inputStream = (type.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : type.getClassLoader()).getResourceAsStream(type.getName().replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
                if (inputStream == null) {
                    return Illegal.INSTANCE;
                }
                try {
                    return new Explicit(new StreamDrainer().drain(inputStream));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public boolean isResolved() {
                return true;
            }

            @Override
            public byte[] resolve() {
                return this.binaryRepresentation;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.binaryRepresentation, ((Explicit)other).binaryRepresentation);
            }

            public int hashCode() {
                return Arrays.hashCode(this.binaryRepresentation);
            }

            public String toString() {
                return "ClassFileLocator.Resolution.Explicit{binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
            }
        }

        public static enum Illegal implements Resolution
        {
            INSTANCE;


            @Override
            public boolean isResolved() {
                return false;
            }

            @Override
            public byte[] resolve() {
                throw new IllegalStateException("Could not read binary data");
            }

            public String toString() {
                return "ClassFileLocator.Resolution.Illegal." + this.name();
            }
        }
    }
}

