/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.subclass;

import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.MethodRegistry;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.LatentMethodMatcher;

public interface ConstructorStrategy {
    public MethodList extractConstructors(TypeDescription var1);

    public MethodRegistry inject(MethodRegistry var1, MethodAttributeAppender.Factory var2);

    public static enum Default implements ConstructorStrategy
    {
        NO_CONSTRUCTORS{

            @Override
            public MethodList extractConstructors(TypeDescription superType) {
                return new MethodList.Empty();
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory defaultMethodAttributeAppenderFactory) {
                return methodRegistry;
            }
        }
        ,
        DEFAULT_CONSTRUCTOR{

            @Override
            public MethodList extractConstructors(TypeDescription instrumentedType) {
                MethodList.Empty methodList;
                TypeDescription superType = instrumentedType.getSupertype();
                MethodList methodList2 = methodList = superType == null ? new MethodList.Empty() : (MethodList)superType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isVisibleTo(instrumentedType)));
                if (methodList.size() == 1) {
                    return methodList;
                }
                throw new IllegalArgumentException(String.format("%s does not declare a default constructor that is visible to %s", instrumentedType.getSupertype(), instrumentedType));
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory defaultMethodAttributeAppenderFactory) {
                return methodRegistry.append(new LatentMethodMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), defaultMethodAttributeAppenderFactory);
            }
        }
        ,
        IMITATE_SUPER_TYPE{

            @Override
            public MethodList extractConstructors(TypeDescription instrumentedType) {
                TypeDescription superType = instrumentedType.getSupertype();
                return superType == null ? new MethodList.Empty() : (MethodList)superType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.isVisibleTo(instrumentedType)));
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory defaultMethodAttributeAppenderFactory) {
                return methodRegistry.append(new LatentMethodMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), defaultMethodAttributeAppenderFactory);
            }
        }
        ,
        IMITATE_SUPER_TYPE_PUBLIC{

            @Override
            public MethodList extractConstructors(TypeDescription instrumentedType) {
                TypeDescription superType = instrumentedType.getSupertype();
                return superType == null ? new MethodList.Empty() : (MethodList)superType.getDeclaredMethods().filter(ElementMatchers.isPublic().and(ElementMatchers.isConstructor()));
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory defaultMethodAttributeAppenderFactory) {
                return methodRegistry.append(new LatentMethodMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), defaultMethodAttributeAppenderFactory);
            }
        };


        public String toString() {
            return "ConstructorStrategy.Default." + this.name();
        }
    }
}

