/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.modifier;

import java.util.Arrays;
import java.util.Collection;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface ModifierContributor {
    public static final int EMPTY_MASK = 0;

    public int getMask();

    public int getRange();

    public boolean isDefault();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Resolver<T extends ModifierContributor> {
        private final Collection<? extends T> modifierContributors;

        protected Resolver(Collection<? extends T> modifierContributors) {
            this.modifierContributors = modifierContributors;
        }

        public static Resolver<ForType> of(ForType ... modifierContributor) {
            return Resolver.of(Arrays.asList(modifierContributor));
        }

        public static Resolver<ForModule> of(ForModule ... modifierContributor) {
            return Resolver.of(Arrays.asList(modifierContributor));
        }

        public static Resolver<ForModule.OfRequire> of(ForModule.OfRequire ... modifierContributor) {
            return Resolver.of(Arrays.asList(modifierContributor));
        }

        public static Resolver<ForModule.OfExport> of(ForModule.OfExport ... modifierContributor) {
            return Resolver.of(Arrays.asList(modifierContributor));
        }

        public static Resolver<ForModule.OfOpen> of(ForModule.OfOpen ... modifierContributor) {
            return Resolver.of(Arrays.asList(modifierContributor));
        }

        public static Resolver<ForField> of(ForField ... modifierContributor) {
            return Resolver.of(Arrays.asList(modifierContributor));
        }

        public static Resolver<ForMethod> of(ForMethod ... modifierContributor) {
            return Resolver.of(Arrays.asList(modifierContributor));
        }

        public static Resolver<ForParameter> of(ForParameter ... modifierContributor) {
            return Resolver.of(Arrays.asList(modifierContributor));
        }

        public static <S extends ModifierContributor> Resolver<S> of(Collection<? extends S> modifierContributors) {
            return new Resolver<S>(modifierContributors);
        }

        public int resolve() {
            return this.resolve(0);
        }

        public int resolve(int modifiers) {
            for (ModifierContributor modifierContributor : this.modifierContributors) {
                modifiers = modifiers & ~modifierContributor.getRange() | modifierContributor.getMask();
            }
            return modifiers;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.modifierContributors).equals(((Resolver)object).modifierContributors);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.modifierContributors).hashCode();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ForParameter
    extends ModifierContributor {
        public static final int MASK = 36880;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ForMethod
    extends ModifierContributor {
        public static final int MASK = 7679;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ForField
    extends ModifierContributor {
        public static final int MASK = 151775;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ForModule
    extends ModifierContributor {
        public static final int MASK = 36896;

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static interface OfOpen
        extends ModifierContributor {
            public static final int MASK = 36928;
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static interface OfExport
        extends ModifierContributor {
            public static final int MASK = 36928;
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static interface OfRequire
        extends ModifierContributor {
            public static final int MASK = 36896;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ForType
    extends ModifierContributor {
        public static final int MASK = 163359;
    }
}

