/*
 * Copyright 2014 - Present Rafael Winterhalter
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * All types and classes in this package are responsible for writing attributes for a given Java byte code element,
 * i.e. fields, types and byte code methods. A common Java attribute is a Java annotation which are represented by
 * the {@link java.lang.annotation.Annotation} interface.
 */
@NeverNull.ByDefault
package net.bytebuddy.implementation.attribute;

import net.bytebuddy.utility.nullability.NeverNull;
