/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.base;

import com.kscs.util.plugins.xjc.base.BooleanOption;
import com.kscs.util.plugins.xjc.base.Opt;
import com.kscs.util.plugins.xjc.base.Option;
import com.kscs.util.plugins.xjc.base.PlainTextUsageBuilder;
import com.kscs.util.plugins.xjc.base.PropertyDirectoryResourceBundle;
import com.kscs.util.plugins.xjc.base.StringOption;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class AbstractPlugin
extends Plugin {
    private static final Set<String> XJC_STANDARD_ARGS = new HashSet<String>(Arrays.asList("-nv", "-extension", "-b", "-d", "-p", "-httpproxy", "-httpproxyfile", "-classpath", "-catalog", "-readOnly", "-npa", "-no-header", "-target", "-encoding", "-enableIntrospection", "-contentForWildcard", "-xmlschema", "-relaxng", "-relaxng-compact", "-dtd", "-wsdl", "-verbose", "-quiet", "-help", "-version", "-fullversion", "-Xinject-code", "-Xlocator", "-Xsync-methods", "-mark-generated", "-episode"));
    private final ResourceBundle baseResourceBundle = PropertyDirectoryResourceBundle.getInstance(AbstractPlugin.class);
    private final ResourceBundle resourceBundle = PropertyDirectoryResourceBundle.getInstance(((Object)((Object)this)).getClass());
    private final List<Option<?>> options = AbstractPlugin.buildOptions(this, ((Object)((Object)this)).getClass());

    protected AbstractPlugin() {
    }

    private static List<Option<?>> buildOptions(AbstractPlugin plugin, Class<?> pluginClass) {
        ArrayList options = new ArrayList();
        if (pluginClass.getSuperclass() != null) {
            options.addAll(AbstractPlugin.buildOptions(plugin, pluginClass.getSuperclass()));
        }
        for (Field field : pluginClass.getDeclaredFields()) {
            String optionName;
            if (!field.isAnnotationPresent(Opt.class)) continue;
            String string = optionName = field.getAnnotation(Opt.class).value().isEmpty() ? field.getName() : field.getAnnotation(Opt.class).value();
            if (field.getType().equals(String.class)) {
                options.add(new StringOption(optionName, plugin, field));
                continue;
            }
            if (!field.getType().equals(Boolean.class) && !field.getType().equals(Boolean.TYPE)) continue;
            options.add(new BooleanOption(optionName, plugin, field));
        }
        return options;
    }

    public boolean isForPlugin(String arg) {
        return arg.toLowerCase().startsWith("-" + this.getOptionName().substring(1).toLowerCase() + ".");
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        int count = 0;
        String currentArg = args[i];
        if (this.isForPlugin(currentArg)) {
            boolean hasMatch = false;
            for (Option<?> option : this.options) {
                if (!option.tryParse(currentArg)) continue;
                hasMatch = true;
                ++count;
            }
            if (!hasMatch) {
                throw new BadCommandLineException(MessageFormat.format(this.baseResourceBundle.getString("exception.unrecognizedArgument"), this.getOptionName().substring(1), currentArg));
            }
        }
        return count;
    }

    private boolean isEndOfPluginArgs(String arg) {
        return XJC_STANDARD_ARGS.contains(arg) || arg.startsWith("-X") || arg.startsWith("-B-X");
    }

    public String getUsage() {
        PlainTextUsageBuilder pluginUsageBuilder = new PlainTextUsageBuilder(this.baseResourceBundle, this.resourceBundle);
        pluginUsageBuilder.addMain(this.getOptionName().substring(1));
        for (Option<?> option : this.options) {
            pluginUsageBuilder.addOption((Option)option);
        }
        return pluginUsageBuilder.build();
    }

    protected String getMessage(String key, Object ... args) {
        return MessageFormat.format(this.resourceBundle.getString(key), args);
    }

    protected String getMessage(String key) {
        return this.resourceBundle.getString(key);
    }

    public List<Option<?>> getOptions() {
        return this.options;
    }
}

