/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import net.dongliu.apk.parser.bean.CertificateMeta;

public class CertificateMetas {
    public static List<CertificateMeta> from(List<X509Certificate> certificates) throws CertificateEncodingException {
        ArrayList<CertificateMeta> certificateMetas = new ArrayList<CertificateMeta>(certificates.size());
        for (X509Certificate certificate : certificates) {
            CertificateMeta certificateMeta = CertificateMetas.from(certificate);
            certificateMetas.add(certificateMeta);
        }
        return certificateMetas;
    }

    public static CertificateMeta from(X509Certificate certificate) throws CertificateEncodingException {
        byte[] bytes = certificate.getEncoded();
        String certMd5 = CertificateMetas.md5Digest(bytes);
        String publicKeyString = CertificateMetas.byteToHexString(bytes);
        String certBase64Md5 = CertificateMetas.md5Digest(publicKeyString);
        return new CertificateMeta(certificate.getSigAlgName().toUpperCase(), certificate.getSigAlgOID(), certificate.getNotBefore(), certificate.getNotAfter(), bytes, certBase64Md5, certMd5);
    }

    private static String md5Digest(byte[] input) {
        MessageDigest digest = CertificateMetas.getDigest("md5");
        digest.update(input);
        return CertificateMetas.getHexString(digest.digest());
    }

    private static String md5Digest(String input) {
        MessageDigest digest = CertificateMetas.getDigest("md5");
        digest.update(input.getBytes(StandardCharsets.UTF_8));
        return CertificateMetas.getHexString(digest.digest());
    }

    private static String byteToHexString(byte[] bArray) {
        StringBuilder sb = new StringBuilder(bArray.length);
        for (byte aBArray : bArray) {
            String sTemp = Integer.toHexString(0xFF & (char)aBArray);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    private static String getHexString(byte[] digest) {
        BigInteger bi = new BigInteger(1, digest);
        return String.format("%032x", bi);
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

