/*
 * Decompiled with CFR 0.152.
 */
package net.erdfelt.android.apk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.erdfelt.android.apk.io.IO;
import net.erdfelt.android.apk.xml.Attribute;
import net.erdfelt.android.apk.xml.BinaryXmlListener;
import net.erdfelt.android.apk.xml.BinaryXmlParser;

public class AndroidApk {
    private String appVersion;
    private String appVersionCode;
    private String packageName;
    private String minSdkVersion;
    private String targetSdkVersion;
    private String maxSdkVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidApk(File apkfile) throws ZipException, IOException {
        ZipFile zip = new ZipFile(apkfile);
        ZipEntry manifestEntry = zip.getEntry("AndroidManifest.xml");
        if (manifestEntry == null) {
            throw new FileNotFoundException("Cannot find AndroidManifest.xml in apk");
        }
        InputStream in = null;
        try {
            in = zip.getInputStream(manifestEntry);
            this.parseStream(in);
        }
        finally {
            IO.close(in);
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidApk(InputStream apkfileInputStream) throws IOException {
        ZipInputStream in = null;
        try {
            ZipEntry ze;
            ZipInputStream is = new ZipInputStream(apkfileInputStream);
            while ((ze = is.getNextEntry()) != null && !ze.getName().endsWith("AndroidManifest.xml")) {
            }
            in = is;
            if (ze == null) {
                throw new FileNotFoundException("Cannot find AndroidManifest.xml in apk");
            }
            this.parseStream(in);
        }
        catch (Throwable throwable) {
            IO.close(in);
            throw throwable;
        }
        IO.close(in);
    }

    private void parseStream(InputStream in) throws IOException {
        BinaryXmlParser parser = new BinaryXmlParser();
        parser.addListener(new ManifestListener());
        parser.parse(in);
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppVersionCode() {
        return this.appVersionCode;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public String getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    public String getMaxSdkVersion() {
        return this.maxSdkVersion;
    }

    private class ManifestListener
    implements BinaryXmlListener {
        private ManifestListener() {
        }

        public void onXmlEntry(String path, String name, Attribute ... attrs) {
            if ("//".equals(path) && "manifest".equals(name)) {
                for (Attribute attrib : attrs) {
                    if ("package".equals(attrib.getName())) {
                        AndroidApk.this.packageName = attrib.getValue();
                        continue;
                    }
                    if ("versionName".equals(attrib.getName())) {
                        AndroidApk.this.appVersion = attrib.getValue();
                        continue;
                    }
                    if (!"versionCode".equals(attrib.getName())) continue;
                    AndroidApk.this.appVersionCode = attrib.getValue();
                }
            }
            if ("uses-sdk".equals(name)) {
                for (Attribute attrib : attrs) {
                    if ("minSdkVersion".equals(attrib.getName())) {
                        AndroidApk.this.minSdkVersion = attrib.getValue();
                        continue;
                    }
                    if ("targetSdkVersion".equals(attrib.getName())) {
                        AndroidApk.this.targetSdkVersion = attrib.getValue();
                        continue;
                    }
                    if (!"maxSdkVersion".equals(attrib.getName())) continue;
                    AndroidApk.this.maxSdkVersion = attrib.getValue();
                }
            }
        }
    }
}

