/*
 * Decompiled with CFR 0.152.
 */
package net.erdfelt.android.apk.xml;

import java.io.IOException;
import net.erdfelt.android.apk.xml.BinaryXmlInputStream;
import net.erdfelt.android.apk.xml.Namespace;

public class Attribute {
    private static final int TYPE_STRING = 0x3000008;
    private static final int TYPE_ID_REF = 0x1000008;
    private static final int TYPE_INT = 0x10000008;
    private Namespace namespace;
    private String name;
    private String value;

    public Attribute(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Attribute(BinaryXmlInputStream le) throws IOException {
        this.namespace = le.readNamespaceRef();
        this.name = le.readStringRef();
        this.value = le.readStringRef();
        int valueType = le.readInt();
        int valueData = le.readInt();
        switch (valueType) {
            case 0x3000008: {
                this.value = le.getString(valueData);
                break;
            }
            case 0x10000008: {
                this.value = Integer.toString(valueData);
                break;
            }
            case 0x1000008: {
                this.value = String.format("@id/0x%08X", valueData);
                break;
            }
            default: {
                this.value = String.format("(0x%08X/0x%08X)", valueType, valueData);
            }
        }
    }

    public String toString() {
        return String.format("%s%s=\"%s\"", this.namespace, this.name, this.value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }
}

