/*
 * Decompiled with CFR 0.152.
 */
package net.erdfelt.android.apk.xml;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.erdfelt.android.apk.xml.Attribute;
import net.erdfelt.android.apk.xml.BinaryXmlInputStream;
import net.erdfelt.android.apk.xml.BinaryXmlListener;
import net.erdfelt.android.apk.xml.Namespace;

public class BinaryXmlParser {
    public static final int END_OF_STREAM = -1;
    public static final int AXML_FILE = 524291;
    public static final int RESOURCE_IDS = 524672;
    public static final int STRING_TABLE = 0x1C0001;
    public static final int DOC_START = 0x100100;
    public static final int DOC_END = 0x100104;
    public static final int NS_START = 0x100100;
    public static final int NS_END = 0x100101;
    public static final int TAG_START = 0x100102;
    public static final int TAG_END = 0x100103;
    public static final int XML_TEXT = 0x100104;
    private List<BinaryXmlListener> listeners = new ArrayList<BinaryXmlListener>();
    private int[] resourceIds;
    private Stack<String> pathStack = new Stack();

    public void addListener(BinaryXmlListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void parse(InputStream in) throws IOException {
        BinaryXmlInputStream le = new BinaryXmlInputStream(in);
        try {
            boolean done = false;
            while (!done) {
                done = this.parseChunk(le);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private boolean parseChunk(BinaryXmlInputStream le) throws IOException {
        int chunkId = le.readChunkId();
        switch (chunkId) {
            case 524291: {
                le.skipInt();
                break;
            }
            case 0x1C0001: {
                le.readStringTableDef();
                break;
            }
            case 524672: {
                this.parseResourceIds(le);
                break;
            }
            case 0x100100: {
                le.readNamespaceDef(true);
                break;
            }
            case 0x100101: {
                le.readNamespaceDef(false);
                break;
            }
            case 0x100102: {
                this.parseTag(le);
                break;
            }
            case 0x100103: {
                this.parseTagEnd(le);
                break;
            }
            case 0x100104: {
                this.parseText(le);
                break;
            }
            case -1: {
                return true;
            }
            default: {
                System.out.printf("Unknown Chunk ID 0x%08X (%d)%n", chunkId, chunkId);
                for (int i = 0; i < 8; ++i) {
                    le.unknownInt("debug");
                }
                return true;
            }
        }
        return false;
    }

    private void parseResourceIds(BinaryXmlInputStream le) throws IOException {
        int chunkSize = le.readInt();
        this.resourceIds = le.readIntArray(chunkSize / 4 - 2);
    }

    private void parseTag(BinaryXmlInputStream le) throws IOException {
        int chunkSize = le.readInt();
        int lineNumber = le.readInt();
        le.skipInt();
        Namespace namespace = le.readNamespaceRef();
        String name = le.readStringRef();
        le.skipInt();
        int attributeCount = le.readInt();
        int idAttribute = (attributeCount >>> 16) - 1;
        int classAttribute = le.readInt();
        int styleAttribute = (classAttribute >>> 16) - 1;
        classAttribute = (classAttribute & 0xFFFF) - 1;
        Attribute[] attribs = new Attribute[attributeCount &= 0xFFFF];
        for (int i = 0; i < attributeCount; ++i) {
            attribs[i] = new Attribute(le);
        }
        String path = this.getCurrentPath();
        for (BinaryXmlListener listener : this.listeners) {
            listener.onXmlEntry(path, name, attribs);
        }
        this.pathStack.push(name);
    }

    private String getCurrentPath() {
        StringBuilder sb = new StringBuilder();
        sb.append("//");
        for (String path : this.pathStack) {
            sb.append(path).append("/");
        }
        return sb.toString();
    }

    private void parseTagEnd(BinaryXmlInputStream le) throws IOException {
        int chunkSize = le.readInt();
        int lineNumber = le.readInt();
        le.skipInt();
        Namespace namespace = le.readNamespaceRef();
        String name = le.readStringRef();
        this.pathStack.pop();
    }

    private void parseText(BinaryXmlInputStream le) throws IOException {
        String text = le.readStringRef();
        le.skipInt();
        le.skipInt();
        System.out.printf("# Text \"%s\"%n", text);
    }
}

