/*
 * Decompiled with CFR 0.152.
 */
package net.gpedro.integrations.slack;

import com.google.gson.JsonObject;
import net.gpedro.integrations.slack.SlackActionStyle;
import net.gpedro.integrations.slack.SlackActionType;

public class SlackAction {
    private static final String NAME = "name";
    private static final String TEXT = "text";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String CONFIRM = "confirm";
    private static final String STYLE = "style";
    private static final String OPTIONS = "options";
    private static final String OPTION_GROUPS = "option_groups";
    private static final String DATA_SOURCE = "data_source";
    private static final String SELECTED_OPTIONS = "selected_options";
    private static final String MIN_QUERY_LENGTH = "min_query_length";
    private String name;
    private String text;
    private SlackActionType type;
    private String value;
    private SlackActionStyle style;

    public SlackAction(String name, String text, SlackActionType type, String value) {
        this.name = name;
        this.text = text;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public SlackActionType getType() {
        return this.type;
    }

    public void setType(SlackActionType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SlackActionStyle getStyle() {
        return this.style;
    }

    public void setStyle(SlackActionStyle style) {
        this.style = style;
    }

    public JsonObject toJson() {
        JsonObject data = new JsonObject();
        data.addProperty(NAME, this.name);
        data.addProperty(TEXT, this.text);
        if (this.type != null) {
            data.addProperty(TYPE, this.type.getCode());
        }
        data.addProperty(VALUE, this.value);
        if (this.style != null) {
            data.addProperty(STYLE, this.style.getCode());
        }
        return data;
    }
}

