/*
 * Decompiled with CFR 0.152.
 */
package net.gpedro.integrations.slack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.gpedro.integrations.slack.SlackAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlackMessage {
    private static final String CHANNEL = "channel";
    private static final String USERNAME = "username";
    private static final String HTTP = "http";
    private static final String ICON_URL = "icon_url";
    private static final String ICON_EMOJI = "icon_emoji";
    private static final String UNFURL_MEDIA = "unfurl_media";
    private static final String UNFURL_LINKS = "unfurl_links";
    private static final String TEXT = "text";
    private static final String ATTACHMENTS = "attachments";
    private static final String LINK_NAMES = "link_names";
    private List<SlackAttachment> attach = new ArrayList<SlackAttachment>();
    private String channel = null;
    private String icon = null;
    private JsonObject slackMessage = new JsonObject();
    private String text = null;
    private String username = null;
    private boolean unfurlMedia = false;
    private boolean unfurlLinks = false;
    private boolean linkNames = false;

    public SlackMessage() {
    }

    public SlackMessage(String text) {
        this(null, null, text);
    }

    public SlackMessage(String username, String text) {
        this(null, username, text);
    }

    public SlackMessage(String channel, String username, String text) {
        if (channel != null) {
            this.channel = channel;
        }
        if (username != null) {
            this.username = username;
        }
        this.text = text;
    }

    public SlackMessage addAttachments(SlackAttachment attach) {
        this.attach.add(attach);
        return this;
    }

    public JsonObject prepare() {
        if (this.channel != null) {
            this.slackMessage.addProperty(CHANNEL, this.channel);
        }
        if (this.username != null) {
            this.slackMessage.addProperty(USERNAME, this.username);
        }
        if (this.icon != null) {
            if (this.icon.contains(HTTP)) {
                this.slackMessage.addProperty(ICON_URL, this.icon);
            } else {
                this.slackMessage.addProperty(ICON_EMOJI, this.icon);
            }
        }
        this.slackMessage.addProperty(UNFURL_MEDIA, Boolean.valueOf(this.unfurlMedia));
        this.slackMessage.addProperty(UNFURL_LINKS, Boolean.valueOf(this.unfurlLinks));
        this.slackMessage.addProperty(LINK_NAMES, Boolean.valueOf(this.linkNames));
        if (this.text == null) {
            throw new IllegalArgumentException("Missing Text field @ SlackMessage");
        }
        this.slackMessage.addProperty(TEXT, this.text);
        if (!this.attach.isEmpty()) {
            this.slackMessage.add(ATTACHMENTS, (JsonElement)this.prepareAttach());
        }
        return this.slackMessage;
    }

    private JsonArray prepareAttach() {
        JsonArray attachs = new JsonArray();
        for (SlackAttachment attach : this.attach) {
            attachs.add((JsonElement)attach.toJson());
        }
        return attachs;
    }

    public SlackMessage removeAttachment(int index) {
        this.attach.remove(index);
        return this;
    }

    public SlackMessage setAttachments(List<SlackAttachment> attach) {
        this.attach = attach;
        return this;
    }

    public SlackMessage setChannel(String channel) {
        if (channel != null) {
            this.channel = channel;
        }
        return this;
    }

    public SlackMessage setIcon(String icon) {
        if (icon != null) {
            this.icon = icon;
        }
        return this;
    }

    public SlackMessage setText(String message) {
        if (message != null) {
            this.text = message;
        }
        return this;
    }

    public SlackMessage setUsername(String username) {
        if (username != null) {
            this.username = username;
        }
        return this;
    }

    public SlackMessage setUnfurlMedia(boolean unfurlMedia) {
        this.unfurlMedia = unfurlMedia;
        return this;
    }

    public SlackMessage setUnfurlLinks(boolean unfurlLinks) {
        this.unfurlLinks = unfurlLinks;
        return this;
    }

    public SlackMessage setLinkNames(boolean linkNames) {
        this.linkNames = linkNames;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackMessage that = (SlackMessage)o;
        if (this.unfurlMedia != that.unfurlMedia) {
            return false;
        }
        if (this.unfurlLinks != that.unfurlLinks) {
            return false;
        }
        if (this.linkNames != that.linkNames) {
            return false;
        }
        if (this.attach != null ? !this.attach.equals(that.attach) : that.attach != null) {
            return false;
        }
        if (this.channel != null ? !this.channel.equals(that.channel) : that.channel != null) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(that.icon) : that.icon != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        return !(this.username == null ? that.username != null : !this.username.equals(that.username));
    }

    public int hashCode() {
        int result = this.attach != null ? this.attach.hashCode() : 0;
        result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
        result = 31 * result + (this.icon != null ? this.icon.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.unfurlMedia ? 1 : 0);
        result = 31 * result + (this.unfurlLinks ? 1 : 0);
        result = 31 * result + (this.linkNames ? 1 : 0);
        return result;
    }

    public String toString() {
        return "SlackMessage{attach=" + this.attach + ", channel='" + this.channel + '\'' + ", icon='" + this.icon + '\'' + ", slackMessage=" + this.slackMessage + ", text='" + this.text + '\'' + ", username='" + this.username + '\'' + ", unfurlMedia=" + this.unfurlMedia + ", unfurlLinks=" + this.unfurlLinks + ", linkNames=" + this.linkNames + '}';
    }
}

