/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.javacrumbs.jsonunit.core.internal.Node;

public final class Path {
    private final String path;
    private final String pathPrefix;
    private static final Pattern arrayPattern = Pattern.compile("(.*)\\[(-?\\d+)]");
    private static final Pattern dotWithPreviousChar = Pattern.compile("[^\\\\]\\.");

    private Path(String path, String pathPrefix) {
        this.path = path;
        this.pathPrefix = pathPrefix;
    }

    public static Path root() {
        return Path.create("", "");
    }

    public static Path create(String path) {
        return Path.create(path, "");
    }

    public static Path create(String path, String pathPrefix) {
        return new Path(path, pathPrefix);
    }

    public Path copy(String newPath) {
        return new Path(newPath, this.pathPrefix);
    }

    public Path asPrefix() {
        return new Path("", this.getFullPath());
    }

    String getPath() {
        return this.path;
    }

    String getFullPath() {
        if (this.pathPrefix.isEmpty()) {
            return this.path;
        }
        if (this.path.startsWith("[")) {
            return this.pathPrefix + this.path;
        }
        if (!this.path.isEmpty()) {
            return this.pathPrefix + "." + this.path;
        }
        return this.pathPrefix;
    }

    Path toField(String name) {
        if (this.isRoot()) {
            return this.copy(name);
        }
        return this.copy(this.path + "." + name);
    }

    Path toElement(int i) {
        return this.copy(this.path + "[" + i + "]");
    }

    Path length() {
        return this.toField("length()");
    }

    public Path to(String name) {
        if (name.startsWith("[")) {
            return this.copy(this.path + name);
        }
        return this.toField(name);
    }

    public String toString() {
        return this.getFullPath();
    }

    Node getNode(Node root) {
        if (this.isRoot()) {
            return root;
        }
        Node startNode = root;
        Matcher pathMatcher = dotWithPreviousChar.matcher(this.path);
        int pos = 0;
        while (pathMatcher.find()) {
            String step = this.path.substring(pos, pathMatcher.end() - 1);
            pos = pathMatcher.end();
            startNode = Path.doStep(step, startNode);
        }
        startNode = Path.doStep(this.path.substring(pos), startNode);
        return startNode;
    }

    private boolean isRoot() {
        return this.path.isEmpty();
    }

    private static Node doStep(String step, Node startNode) {
        Matcher matcher = arrayPattern.matcher(step = step.replaceAll("\\\\\\.", "."));
        if (!matcher.matches()) {
            startNode = startNode.get(step);
        } else {
            int index;
            if (!matcher.group(1).isEmpty()) {
                startNode = startNode.get(matcher.group(1));
            }
            startNode = (index = Integer.parseInt(matcher.group(2))) < 0 ? startNode.element(startNode.size() + index) : startNode.element(index);
        }
        return startNode;
    }
}

