/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.EvaluationListener;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.ArrayList;
import java.util.List;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.jsonpath.InternalJsonPathUtils;
import org.jspecify.annotations.Nullable;

public final class JsonPathAdapter {
    private JsonPathAdapter() {
    }

    public static Object inPath(@Nullable Object json, String path) {
        try {
            MatchRecordingListener recordingListener = new MatchRecordingListener();
            Object value = InternalJsonPathUtils.readValue(Configuration.defaultConfiguration().addEvaluationListeners(new EvaluationListener[]{recordingListener}), json, path);
            return JsonUtils.jsonSource((Object)JsonUtils.wrapDeserializedObject(value), (String)JsonPathAdapter.concatJsonPaths(json, path), recordingListener.getMatchingPaths());
        }
        catch (PathNotFoundException e) {
            return JsonUtils.jsonSource((Object)JsonUtils.missingNode(), (String)JsonPathAdapter.concatJsonPaths(json, path));
        }
    }

    private static String concatJsonPaths(@Nullable Object json, String path) {
        String newPathSegment = InternalJsonPathUtils.fromBracketNotation(path);
        String pathPrefix = JsonUtils.getPathPrefix((Object)json);
        if (pathPrefix.isEmpty()) {
            return newPathSegment;
        }
        if (newPathSegment.startsWith("$.")) {
            return pathPrefix + newPathSegment.substring(1);
        }
        if (newPathSegment.startsWith("[")) {
            return pathPrefix + newPathSegment;
        }
        return pathPrefix + "." + newPathSegment;
    }

    private static class MatchRecordingListener
    implements EvaluationListener {
        private final List<String> matchingPaths = new ArrayList<String>();

        private MatchRecordingListener() {
        }

        public EvaluationListener.EvaluationContinuation resultFound(EvaluationListener.FoundResult foundResult) {
            this.matchingPaths.add(InternalJsonPathUtils.fromBracketNotation(foundResult.path()));
            return EvaluationListener.EvaluationContinuation.CONTINUE;
        }

        List<String> getMatchingPaths() {
            return this.matchingPaths;
        }
    }
}

