/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockAssert;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockExtender;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLockingTaskExecutor
implements LockingTaskExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLockingTaskExecutor.class);
    @NonNull
    private final LockProvider lockProvider;

    public DefaultLockingTaskExecutor(@NonNull LockProvider lockProvider) {
        this.lockProvider = Objects.requireNonNull(lockProvider);
    }

    @Override
    public void executeWithLock(@NonNull Runnable task, @NonNull LockConfiguration lockConfig) {
        try {
            this.executeWithLock(task::run, lockConfig);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    @Override
    public void executeWithLock(@NonNull LockingTaskExecutor.Task task, @NonNull LockConfiguration lockConfig) throws Throwable {
        this.executeWithLock(() -> {
            task.call();
            return null;
        }, lockConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T> LockingTaskExecutor.TaskResult<T> executeWithLock(@NonNull LockingTaskExecutor.TaskWithResult<T> task, @NonNull LockConfiguration lockConfig) throws Throwable {
        Optional<SimpleLock> lock = this.lockProvider.lock(lockConfig);
        String lockName = lockConfig.getName();
        if (LockAssert.alreadyLockedBy(lockName)) {
            logger.debug("Already locked '{}'", (Object)lockName);
            return LockingTaskExecutor.TaskResult.result(task.call());
        }
        if (lock.isPresent()) {
            try {
                LockAssert.startLock(lockName);
                LockExtender.startLock(lock.get());
                logger.debug("Locked '{}', lock will be held at most until {}", (Object)lockName, (Object)lockConfig.getLockAtMostUntil());
                LockingTaskExecutor.TaskResult<T> taskResult = LockingTaskExecutor.TaskResult.result(task.call());
                return taskResult;
            }
            finally {
                LockAssert.endLock();
                SimpleLock activeLock = LockExtender.endLock();
                if (activeLock != null) {
                    activeLock.unlock();
                } else {
                    logger.warn("No active lock, please report this as a bug.");
                    lock.get().unlock();
                }
                if (logger.isDebugEnabled()) {
                    Instant now;
                    Instant lockAtLeastUntil = lockConfig.getLockAtLeastUntil();
                    if (lockAtLeastUntil.isAfter(now = ClockProvider.now())) {
                        logger.debug("Task finished, lock '{}' will be released at {}", (Object)lockName, (Object)lockAtLeastUntil);
                    } else {
                        logger.debug("Task finished, lock '{}' released", (Object)lockName);
                    }
                }
            }
        }
        logger.debug("Not executing '{}'. It's locked.", (Object)lockName);
        return LockingTaskExecutor.TaskResult.notExecuted();
    }
}

