/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import net.javacrumbs.shedlock.support.annotation.NonNull;

public final class LockAssert {
    private static final ThreadLocal<String> currentLockName = ThreadLocal.withInitial(() -> null);

    private LockAssert() {
    }

    static void startLock(String name) {
        currentLockName.set(name);
    }

    static boolean alreadyLockedBy(@NonNull String name) {
        return name.equals(currentLockName.get());
    }

    static void endLock() {
        currentLockName.remove();
    }

    public static void assertLocked() {
        if (currentLockName.get() == null) {
            throw new IllegalStateException("The task is not locked.");
        }
    }

    public static class TestHelper {
        public static void makeAllAssertsPass(boolean pass) {
            if (pass) {
                LockAssert.startLock("net.javacrumbs.shedlock.core.test-lock");
            } else {
                LockAssert.endLock();
            }
        }
    }
}

