/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.support;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveLockProvider
implements LockProvider {
    private final ExtensibleLockProvider wrapped;
    private final ScheduledExecutorService executorService;
    private final Duration minimalLockAtMostFor;
    private static final Logger logger = LoggerFactory.getLogger(KeepAliveLockProvider.class);

    public KeepAliveLockProvider(ExtensibleLockProvider wrapped, ScheduledExecutorService executorService) {
        this(wrapped, executorService, Duration.ofSeconds(30L));
    }

    KeepAliveLockProvider(ExtensibleLockProvider wrapped, ScheduledExecutorService executorService, Duration minimalLockAtMostFor) {
        this.wrapped = wrapped;
        this.executorService = executorService;
        this.minimalLockAtMostFor = minimalLockAtMostFor;
    }

    @Override
    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        if (lockConfiguration.getLockAtMostFor().compareTo(this.minimalLockAtMostFor) < 0) {
            throw new IllegalArgumentException("Can not use KeepAliveLockProvider with lockAtMostFor shorter than " + this.minimalLockAtMostFor);
        }
        Optional<SimpleLock> lock = this.wrapped.lock(lockConfiguration);
        return lock.map(simpleLock -> new KeepAliveLock(lockConfiguration, (SimpleLock)simpleLock, this.executorService));
    }

    private static class KeepAliveLock
    extends AbstractSimpleLock {
        private final Duration lockExtensionPeriod;
        private SimpleLock lock;
        private Duration remainingLockAtLeastFor;
        private final ScheduledFuture<?> future;
        private boolean active = true;
        private Instant currentLockAtMostUntil;

        private KeepAliveLock(LockConfiguration lockConfiguration, SimpleLock lock, ScheduledExecutorService executorService) {
            super(lockConfiguration);
            this.lock = lock;
            this.lockExtensionPeriod = lockConfiguration.getLockAtMostFor().dividedBy(2L);
            this.remainingLockAtLeastFor = lockConfiguration.getLockAtLeastFor();
            this.currentLockAtMostUntil = lockConfiguration.getLockAtMostUntil();
            long extensionPeriodMs = this.lockExtensionPeriod.toMillis();
            this.future = executorService.scheduleAtFixedRate(this::extendForNextPeriod, extensionPeriodMs, extensionPeriodMs, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void extendForNextPeriod() {
            KeepAliveLock keepAliveLock = this;
            synchronized (keepAliveLock) {
                if (!this.active) {
                    return;
                }
                if (this.currentLockAtMostUntil.isBefore(ClockProvider.now())) {
                    this.stop();
                    return;
                }
                this.remainingLockAtLeastFor = this.remainingLockAtLeastFor.minus(this.lockExtensionPeriod);
                if (this.remainingLockAtLeastFor.isNegative()) {
                    this.remainingLockAtLeastFor = Duration.ZERO;
                }
                this.currentLockAtMostUntil = ClockProvider.now().plus(this.lockConfiguration.getLockAtMostFor());
                Optional<SimpleLock> extendedLock = this.lock.extend(this.lockConfiguration.getLockAtMostFor(), this.remainingLockAtLeastFor);
                if (extendedLock.isPresent()) {
                    this.lock = extendedLock.get();
                    logger.trace("Lock {} extended for {}", (Object)this.lockConfiguration.getName(), (Object)this.lockConfiguration.getLockAtMostFor());
                } else {
                    logger.warn("Can't extend lock {}", (Object)this.lockConfiguration.getName());
                    this.stop();
                }
            }
        }

        private void stop() {
            this.active = false;
            this.future.cancel(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doUnlock() {
            KeepAliveLock keepAliveLock = this;
            synchronized (keepAliveLock) {
                this.stop();
                this.lock.unlock();
            }
        }

        @Override
        protected Optional<SimpleLock> doExtend(LockConfiguration newConfiguration) {
            throw new UnsupportedOperationException("Manual extension of KeepAliveLock is not supported (yet)");
        }
    }
}

