/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.spring.ExtendedLockConfigurationExtractor;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import net.javacrumbs.shedlock.support.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.KotlinDetector;
import org.springframework.core.KotlinReflectionParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.PrioritizedParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

class SpringLockConfigurationExtractor
implements ExtendedLockConfigurationExtractor {
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private static final ParserContext PARSER_CONTEXT = new TemplateParserContext();
    public static final PrioritizedParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new PrioritizedParameterNameDiscoverer();
    private final Duration defaultLockAtMostFor;
    private final Duration defaultLockAtLeastFor;
    @Nullable
    private final StringValueResolver embeddedValueResolver;
    @Nullable
    private final BeanFactory beanFactory;
    private final StandardEvaluationContext originalEvaluationContext = new StandardEvaluationContext();
    private final Converter<String, Duration> durationConverter;
    private final Logger logger = LoggerFactory.getLogger(SpringLockConfigurationExtractor.class);

    public SpringLockConfigurationExtractor(Duration defaultLockAtMostFor, Duration defaultLockAtLeastFor, @Nullable StringValueResolver embeddedValueResolver, Converter<String, Duration> durationConverter) {
        this(defaultLockAtMostFor, defaultLockAtLeastFor, embeddedValueResolver, durationConverter, null);
    }

    public SpringLockConfigurationExtractor(Duration defaultLockAtMostFor, Duration defaultLockAtLeastFor, @Nullable StringValueResolver embeddedValueResolver, Converter<String, Duration> durationConverter, @Nullable BeanFactory beanFactory) {
        this.defaultLockAtMostFor = Objects.requireNonNull(defaultLockAtMostFor);
        this.defaultLockAtLeastFor = Objects.requireNonNull(defaultLockAtLeastFor);
        this.durationConverter = Objects.requireNonNull(durationConverter);
        this.embeddedValueResolver = embeddedValueResolver;
        this.beanFactory = beanFactory;
        this.originalEvaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
    }

    public Optional<LockConfiguration> getLockConfiguration(Runnable task) {
        if (task instanceof ScheduledMethodRunnable) {
            ScheduledMethodRunnable scheduledMethodRunnable = (ScheduledMethodRunnable)task;
            return this.getLockConfiguration(scheduledMethodRunnable.getTarget(), scheduledMethodRunnable.getMethod(), new Object[0]);
        }
        this.logger.debug("Unknown task type " + task);
        return Optional.empty();
    }

    @Override
    public Optional<LockConfiguration> getLockConfiguration(Object target, Method method, Object[] parameterValues) {
        AnnotationData annotation = this.findAnnotation(target, method);
        if (this.shouldLock(annotation)) {
            return Optional.of(this.getLockConfiguration(annotation, method, parameterValues));
        }
        return Optional.empty();
    }

    private LockConfiguration getLockConfiguration(AnnotationData annotation, Method method, Object[] parameterValues) {
        return new LockConfiguration(ClockProvider.now(), this.getName(annotation, method, parameterValues), this.getLockAtMostFor(annotation), this.getLockAtLeastFor(annotation));
    }

    private String getName(AnnotationData annotation, Method method, Object[] parameterValues) {
        String name = this.parseSpEL(annotation.getName(), method, parameterValues);
        if (this.embeddedValueResolver != null) {
            return this.embeddedValueResolver.resolveStringValue(name);
        }
        return name;
    }

    private String parseSpEL(String name, Method method, Object[] parameterValues) {
        return this.getEvaluationContext(method, parameterValues).map(evaluationContext -> (String)EXPRESSION_PARSER.parseExpression(name, PARSER_CONTEXT).getValue(evaluationContext, String.class)).orElse(name);
    }

    private Optional<EvaluationContext> getEvaluationContext(Method method, Object[] parameterValues) {
        if (method.getParameters().length > 0 && method.getParameters().length == parameterValues.length) {
            MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext((Object)this.beanFactory, method, parameterValues, (ParameterNameDiscoverer)PARAMETER_NAME_DISCOVERER);
            this.originalEvaluationContext.applyDelegatesTo((StandardEvaluationContext)evaluationContext);
            return Optional.of(evaluationContext);
        }
        return Optional.empty();
    }

    Duration getLockAtMostFor(AnnotationData annotation) {
        return this.getValue(annotation.getLockAtMostFor(), annotation.getLockAtMostForString(), this.defaultLockAtMostFor, "lockAtMostForString");
    }

    Duration getLockAtLeastFor(AnnotationData annotation) {
        return this.getValue(annotation.getLockAtLeastFor(), annotation.getLockAtLeastForString(), this.defaultLockAtLeastFor, "lockAtLeastForString");
    }

    private Duration getValue(long valueFromAnnotation, String stringValueFromAnnotation, Duration defaultValue, String paramName) {
        if (valueFromAnnotation >= 0L) {
            return Duration.of(valueFromAnnotation, ChronoUnit.MILLIS);
        }
        if (StringUtils.hasText((String)stringValueFromAnnotation)) {
            if (this.embeddedValueResolver != null) {
                stringValueFromAnnotation = this.embeddedValueResolver.resolveStringValue(stringValueFromAnnotation);
            }
            try {
                Duration result = (Duration)this.durationConverter.convert((Object)stringValueFromAnnotation);
                if (result.isNegative()) {
                    throw new IllegalArgumentException("Invalid " + paramName + " value \"" + stringValueFromAnnotation + "\" - cannot set negative duration");
                }
                return result;
            }
            catch (IllegalStateException nfe) {
                throw new IllegalArgumentException("Invalid " + paramName + " value \"" + stringValueFromAnnotation + "\" - cannot parse into long nor duration");
            }
        }
        return defaultValue;
    }

    @Nullable
    AnnotationData findAnnotation(Object target, Method method) {
        AnnotationData annotation = this.findAnnotation(method);
        if (annotation != null) {
            return annotation;
        }
        Class targetClass = AopUtils.getTargetClass((Object)target);
        try {
            Method methodOnTarget = targetClass.getMethod(method.getName(), method.getParameterTypes());
            return this.findAnnotation(methodOnTarget);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    private AnnotationData findAnnotation(Method method) {
        SchedulerLock annotation = (SchedulerLock)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, SchedulerLock.class);
        if (annotation != null) {
            return new AnnotationData(annotation.name(), -1L, annotation.lockAtMostFor(), -1L, annotation.lockAtLeastFor());
        }
        return null;
    }

    private boolean shouldLock(@Nullable AnnotationData annotation) {
        return annotation != null;
    }

    static {
        if (KotlinDetector.isKotlinReflectPresent()) {
            PARAMETER_NAME_DISCOVERER.addDiscoverer((ParameterNameDiscoverer)new KotlinReflectionParameterNameDiscoverer());
        }
        PARAMETER_NAME_DISCOVERER.addDiscoverer((ParameterNameDiscoverer)new SimpleParameterNameDiscoverer());
    }

    static class AnnotationData {
        private final String name;
        private final long lockAtMostFor;
        private final String lockAtMostForString;
        private final long lockAtLeastFor;
        private final String lockAtLeastForString;

        private AnnotationData(String name, long lockAtMostFor, String lockAtMostForString, long lockAtLeastFor, String lockAtLeastForString) {
            this.name = name;
            this.lockAtMostFor = lockAtMostFor;
            this.lockAtMostForString = lockAtMostForString;
            this.lockAtLeastFor = lockAtLeastFor;
            this.lockAtLeastForString = lockAtLeastForString;
        }

        public String getName() {
            return this.name;
        }

        public long getLockAtMostFor() {
            return this.lockAtMostFor;
        }

        public String getLockAtMostForString() {
            return this.lockAtMostForString;
        }

        public long getLockAtLeastFor() {
            return this.lockAtLeastFor;
        }

        public String getLockAtLeastForString() {
            return this.lockAtLeastForString;
        }
    }

    private static class SimpleParameterNameDiscoverer
    implements ParameterNameDiscoverer {
        private SimpleParameterNameDiscoverer() {
        }

        @Nullable
        public String[] getParameterNames(Method method) {
            return this.getParameterNames(method.getParameters());
        }

        @Nullable
        public String[] getParameterNames(Constructor<?> ctor) {
            return this.getParameterNames(ctor.getParameters());
        }

        @Nullable
        private String[] getParameterNames(Parameter[] parameters) {
            String[] parameterNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Parameter param = parameters[i];
                if (param.getName() == null) {
                    return null;
                }
                parameterNames[i] = param.getName();
            }
            return parameterNames;
        }
    }
}

