/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.lang.annotation.Annotation;
import java.util.Optional;
import net.javacrumbs.shedlock.core.DefaultLockingTaskExecutor;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import net.javacrumbs.shedlock.spring.ExtendedLockConfigurationExtractor;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import net.javacrumbs.shedlock.spring.aop.LockProviderSupplier;
import net.javacrumbs.shedlock.spring.aop.LockingNotSupportedException;
import net.javacrumbs.shedlock.support.annotation.Nullable;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;

class MethodProxyScheduledLockAdvisor
extends AbstractPointcutAdvisor {
    private final Pointcut pointcut = new ComposablePointcut((Pointcut)MethodProxyScheduledLockAdvisor.methodPointcutFor(SchedulerLock.class));
    private final Advice advice;

    MethodProxyScheduledLockAdvisor(ExtendedLockConfigurationExtractor lockConfigurationExtractor, LockProviderSupplier lockProviderSupplier) {
        this.advice = new LockingInterceptor(lockConfigurationExtractor, lockProviderSupplier);
    }

    private static AnnotationMatchingPointcut methodPointcutFor(Class<? extends Annotation> methodAnnotationType) {
        return new AnnotationMatchingPointcut(null, methodAnnotationType, true);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    private static class LockingInterceptor
    implements MethodInterceptor {
        private final ExtendedLockConfigurationExtractor lockConfigurationExtractor;
        private final LockProviderSupplier lockProviderSupplier;

        LockingInterceptor(ExtendedLockConfigurationExtractor lockConfigurationExtractor, LockProviderSupplier lockProviderSupplier) {
            this.lockConfigurationExtractor = lockConfigurationExtractor;
            this.lockProviderSupplier = lockProviderSupplier;
        }

        @Nullable
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Class<?> returnType = invocation.getMethod().getReturnType();
            if (returnType.isPrimitive() && !Void.TYPE.equals(returnType)) {
                throw new LockingNotSupportedException("Can not lock method returning primitive value");
            }
            LockConfiguration lockConfiguration = this.lockConfigurationExtractor.getLockConfiguration(invocation.getThis(), invocation.getMethod(), invocation.getArguments()).get();
            LockProvider lockProvider = this.lockProviderSupplier.supply(invocation.getThis(), invocation.getMethod(), invocation.getArguments());
            DefaultLockingTaskExecutor lockingTaskExecutor = new DefaultLockingTaskExecutor(lockProvider);
            LockingTaskExecutor.TaskResult result = lockingTaskExecutor.executeWithLock(() -> ((MethodInvocation)invocation).proceed(), lockConfiguration);
            if (Optional.class.equals(returnType)) {
                return LockingInterceptor.toOptional((LockingTaskExecutor.TaskResult<Object>)result);
            }
            return result.getResult();
        }

        @Nullable
        private static Object toOptional(LockingTaskExecutor.TaskResult<Object> result) {
            if (result.wasExecuted()) {
                return result.getResult();
            }
            return Optional.empty();
        }
    }
}

