/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.AsyncCallable;
import net.jodah.recurrent.RecurrentFuture;
import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.RetryStats;
import net.jodah.recurrent.Scheduler;
import net.jodah.recurrent.internal.util.Assert;

public class Invocation
extends RetryStats {
    private final AsyncCallable<Object> callable;
    private final RecurrentFuture<Object> future;
    private final Scheduler scheduler;
    volatile boolean retried;
    volatile boolean completed;

    <T> Invocation(AsyncCallable<T> callable, RetryPolicy retryPolicy, Scheduler scheduler, RecurrentFuture<T> future) {
        super(retryPolicy);
        this.callable = callable;
        this.scheduler = scheduler;
        this.future = future;
    }

    public void complete() {
        this.complete(null, null, false);
    }

    public boolean complete(Object result) {
        return this.complete(result, null, true);
    }

    public boolean completeExceptionally(Throwable failure) {
        return this.complete(null, failure, true);
    }

    public boolean complete(Object result, Throwable failure) {
        return this.complete(result, failure, true);
    }

    public boolean retry() {
        return this.retryOrFail(null, null, false);
    }

    public boolean retryOn(Throwable failure) {
        Assert.notNull(failure, "failure");
        return this.retryOrFail(null, failure, true);
    }

    public boolean retryWhen(Object result) {
        Assert.notNull(result, "result");
        return this.retryOrFail(result, null, true);
    }

    public boolean retryWhen(Object result, Throwable failure) {
        Assert.isTrue(result != null || failure != null, "result or failure must not be null", new Object[0]);
        return this.retryOrFail(result, failure, true);
    }

    void reset() {
        this.retried = false;
        this.completed = false;
    }

    void retryOrComplete(Object result, Throwable failure) {
        if (this.retry(result, failure, true)) {
            return;
        }
        this.future.complete(result, failure);
    }

    private boolean complete(Object result, Throwable failure, boolean checkArgs) {
        Assert.state(!this.completed, "Complete has already been called", new Object[0]);
        this.completed = true;
        if (checkArgs && this.canRetryWhen(result, failure)) {
            return false;
        }
        this.future.complete(result, failure);
        return true;
    }

    private boolean retryOrFail(Object result, Throwable failure, boolean checkArgs) {
        Assert.state(!this.retried, "Retry has already been called", new Object[0]);
        this.retried = true;
        if (this.retry(result, failure, checkArgs)) {
            return true;
        }
        this.completed = true;
        this.future.complete(result, failure == null ? new RuntimeException("Retry invocations exceeded") : failure);
        return false;
    }

    private boolean retry(Object result, Throwable failure, boolean checkArgs) {
        if (checkArgs ? this.canRetryWhen(result, failure) : this.canRetry()) {
            if (!this.future.isDone() && !this.future.isCancelled()) {
                this.future.setFuture(this.scheduler.schedule(this.callable, this.waitTime, TimeUnit.NANOSECONDS));
            }
            return true;
        }
        return false;
    }
}

