/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.AsyncCallable;
import net.jodah.recurrent.Callables;
import net.jodah.recurrent.ContextualCallable;
import net.jodah.recurrent.ContextualRunnable;
import net.jodah.recurrent.Invocation;
import net.jodah.recurrent.RecurrentFuture;
import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.RetryStats;
import net.jodah.recurrent.Scheduler;
import net.jodah.recurrent.Schedulers;

public final class Recurrent {
    private Recurrent() {
    }

    public static <T> CompletableFuture<T> future(Callable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.future(callable, retryPolicy, Schedulers.of(executor));
    }

    public static <T> CompletableFuture<T> future(Callable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, Scheduler scheduler) {
        CompletableFuture response = new CompletableFuture();
        Recurrent.call(AsyncCallable.ofFuture(callable), retryPolicy, scheduler, RecurrentFuture.of(response, scheduler));
        return response;
    }

    public static <T> CompletableFuture<T> future(ContextualCallable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.future(callable, retryPolicy, Schedulers.of(executor));
    }

    public static <T> CompletableFuture<T> future(ContextualCallable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, Scheduler scheduler) {
        CompletableFuture response = new CompletableFuture();
        Recurrent.call(AsyncCallable.ofFuture(callable), retryPolicy, scheduler, RecurrentFuture.of(response, scheduler));
        return response;
    }

    public static <T> T get(Callable<T> callable, RetryPolicy retryPolicy) {
        return Recurrent.call(callable, retryPolicy);
    }

    public static <T> RecurrentFuture<T> get(Callable<T> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, Schedulers.of(executor), null);
    }

    public static <T> RecurrentFuture<T> get(Callable<T> callable, RetryPolicy retryPolicy, Scheduler scheduler) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, scheduler, null);
    }

    public static <T> RecurrentFuture<T> get(ContextualCallable<T> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, Schedulers.of(executor), null);
    }

    public static <T> RecurrentFuture<T> get(ContextualCallable<T> callable, RetryPolicy retryPolicy, Scheduler scheduler) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, scheduler, null);
    }

    public static RecurrentFuture<?> run(ContextualRunnable runnable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, Schedulers.of(executor), null);
    }

    public static RecurrentFuture<?> run(ContextualRunnable runnable, RetryPolicy retryPolicy, Scheduler scheduler) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, scheduler, null);
    }

    public static void run(Runnable runnable, RetryPolicy retryPolicy) {
        Recurrent.call(Callables.of(runnable), retryPolicy);
    }

    public static RecurrentFuture<?> run(Runnable runnable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, Schedulers.of(executor), null);
    }

    public static RecurrentFuture<?> run(Runnable runnable, RetryPolicy retryPolicy, Scheduler scheduler) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, scheduler, null);
    }

    private static <T> RecurrentFuture<T> call(AsyncCallable<T> callable, RetryPolicy retryPolicy, Scheduler scheduler, RecurrentFuture<T> future) {
        if (future == null) {
            future = new RecurrentFuture(scheduler);
        }
        callable.initialize(new Invocation(callable, retryPolicy, scheduler, future));
        future.setFuture(scheduler.schedule(callable, 0L, TimeUnit.MILLISECONDS));
        return future;
    }

    private static <T> T call(Callable<T> callable, RetryPolicy retryPolicy) {
        Throwable failure;
        RetryStats stats = new RetryStats(retryPolicy);
        T result = null;
        while (true) {
            try {
                failure = null;
                result = callable.call();
            }
            catch (Throwable t) {
                failure = t;
            }
            if (!stats.canRetryWhen(result, failure)) break;
            try {
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(stats.waitTime));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (failure == null) {
            return result;
        }
        RuntimeException re = failure instanceof RuntimeException ? (RuntimeException)failure : new RuntimeException(failure);
        throw re;
    }
}

