/*
 * Decompiled with CFR 0.152.
 */
package net.joshka.junit.json.params;

import java.io.Reader;
import java.io.StringReader;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import net.joshka.junit.json.params.JsonSource;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

public class JsonArgumentsProvider
implements AnnotationConsumer<JsonSource>,
ArgumentsProvider {
    private String value;

    public void accept(JsonSource jsonFileSource) {
        this.value = jsonFileSource.value();
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) throws Exception {
        try (StringReader reader = new StringReader(this.value);){
            Stream<Arguments> stream = JsonArgumentsProvider.values(reader).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
            return stream;
        }
    }

    private static Stream<JsonValue> values(Reader reader) {
        try (JsonReader jsonReader = Json.createReader((Reader)reader);){
            JsonStructure structure = jsonReader.read();
            Stream stream = structure.getValueType() == JsonValue.ValueType.ARRAY ? structure.asJsonArray().stream() : Stream.of(structure);
            return stream;
        }
    }
}

