/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.asn1.authenticode;

import net.jsign.asn1.authenticode.AuthenticodeSignedData;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;

public class AuthenticodeSignedDataGenerator
extends CMSSignedDataGenerator {
    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        this.digests.clear();
        SignerInfo signerInfo = this.getSignerInfo(content);
        ContentInfo encInfo = new ContentInfo(content.getContentType(), (ASN1Encodable)content.getContent());
        DERSet certificates = new DERSet(this.certs.toArray(new ASN1Encodable[0]));
        AuthenticodeSignedData signedData = new AuthenticodeSignedData(signerInfo.getDigestAlgorithm(), encInfo, (ASN1Set)certificates, signerInfo);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)signedData);
        return new CMSSignedData((CMSProcessable)content, contentInfo);
    }

    private SignerInfo getSignerInfo(CMSTypedData content) throws CMSException {
        if (!this._signers.isEmpty()) {
            return ((SignerInformation)this._signers.get(0)).toASN1Structure();
        }
        CMSSignedData sigData = super.generate(content, true);
        return ((SignerInformation)sigData.getSignerInfos().iterator().next()).toASN1Structure();
    }
}

