/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.pe;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jsign.pe.PEFile;

class DataDirectory {
    private final PEFile peFile;
    private final int index;

    DataDirectory(PEFile peFile, int index) {
        this.peFile = peFile;
        this.index = index;
    }

    public long getVirtualAddress() throws IOException {
        return this.peFile.readDWord(this.peFile.getDataDirectoryOffset(), this.index * 8);
    }

    public int getSize() throws IOException {
        return (int)this.peFile.readDWord(this.peFile.getDataDirectoryOffset(), this.index * 8 + 4);
    }

    public boolean exists() throws IOException {
        return this.getVirtualAddress() != 0L && this.getSize() != 0;
    }

    void check() throws IOException {
        long address = this.getVirtualAddress();
        int size = this.getSize();
        if (address < 0L || size < 0 || address + (long)size > this.peFile.channel.size()) {
            throw new IOException("Invalid data directory (index=" + this.index + ", address=" + address + ", size=" + size + ")");
        }
    }

    public boolean isTrailing() throws IOException {
        return this.getVirtualAddress() + (long)this.getSize() == this.peFile.channel.size();
    }

    public void write(long virtualAddress, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt((int)virtualAddress);
        buffer.putInt(size);
        buffer.flip();
        this.peFile.write((long)(this.peFile.getDataDirectoryOffset() + this.index * 8), buffer);
    }
}

