/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.mojo;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.nicoulaj.maven.plugins.checksum.Constants;
import net.nicoulaj.maven.plugins.checksum.execution.AbstractExecution;
import net.nicoulaj.maven.plugins.checksum.execution.ExecutionException;
import net.nicoulaj.maven.plugins.checksum.execution.FailOnErrorExecution;
import net.nicoulaj.maven.plugins.checksum.execution.NeverFailExecution;
import net.nicoulaj.maven.plugins.checksum.execution.target.CsvSummaryFileTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.MavenLogTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.OneHashPerFileTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.XmlSummaryFileTarget;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

abstract class AbstractChecksumMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter
    protected List<String> algorithms = Arrays.asList(Constants.DEFAULT_EXECUTION_ALGORITHMS);
    @Parameter(defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding = "UTF-8";
    @Parameter(defaultValue="false")
    protected boolean quiet;

    AbstractChecksumMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        AbstractExecution execution = this.failOnError ? new FailOnErrorExecution() : new NeverFailExecution(this.getLog());
        execution.setAlgorithms(this.algorithms);
        execution.setFiles(this.getFilesToProcess());
        if (!this.quiet) {
            execution.addTarget(new MavenLogTarget(this.getLog()));
        }
        if (this.isIndividualFiles()) {
            File outputDirectory = null;
            if (StringUtils.isNotEmpty((String)this.getIndividualFilesOutputDirectory())) {
                outputDirectory = FileUtils.resolveFile((File)new File(this.project.getBuild().getDirectory()), (String)this.getIndividualFilesOutputDirectory());
            }
            execution.addTarget(new OneHashPerFileTarget(this.encoding, outputDirectory));
        }
        if (this.isCsvSummary()) {
            execution.addTarget(new CsvSummaryFileTarget(FileUtils.resolveFile((File)new File(this.project.getBuild().getDirectory()), (String)this.getCsvSummaryFile()), this.encoding));
        }
        if (this.isXmlSummary()) {
            execution.addTarget(new XmlSummaryFileTarget(FileUtils.resolveFile((File)new File(this.project.getBuild().getDirectory()), (String)this.getXmlSummaryFile()), this.encoding));
        }
        try {
            execution.run();
        }
        catch (ExecutionException e) {
            this.getLog().error((CharSequence)e.getMessage());
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected abstract List<File> getFilesToProcess();

    protected abstract boolean isIndividualFiles();

    protected abstract String getIndividualFilesOutputDirectory();

    protected abstract boolean isCsvSummary();

    protected abstract String getCsvSummaryFile();

    protected abstract boolean isXmlSummary();

    protected abstract String getXmlSummaryFile();
}

