/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.core.util;

import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    private static final int DEFAULT_POLL_INTERVAL_MS = 500;
    private static final ScheduledExecutorService waitConditionPollingExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("wait-condition-polling-thread");
            thread.setDaemon(true);
            return thread;
        }
    });

    public static boolean pollForCondition(WaitCondition condition, long timeout, TimeUnit timeUnit) {
        return ThreadUtils.pollForCondition(condition, timeout, timeUnit, 500L);
    }

    public static boolean pollForCondition(WaitCondition condition, final long timeout, final TimeUnit timeUnit, long pollIntervalMs) {
        if (condition.checkCondition()) {
            return true;
        }
        final WeakReference<WaitCondition> conditionWrapper = new WeakReference<WaitCondition>(condition);
        final CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> pollingTask = waitConditionPollingExecutor.scheduleWithFixedDelay(new Runnable(){
            private final long taskStart = System.currentTimeMillis();

            @Override
            public void run() {
                WaitCondition condition = (WaitCondition)conditionWrapper.get();
                if (condition == null || System.currentTimeMillis() - this.taskStart > TimeUnit.MILLISECONDS.convert(timeout, timeUnit)) {
                    throw new RuntimeException("Stopped polling for condition because time limit elapsed or condition was garbage collected");
                }
                if (condition.checkCondition()) {
                    latch.countDown();
                }
            }
        }, pollIntervalMs, pollIntervalMs, TimeUnit.MILLISECONDS);
        try {
            boolean conditionMet = latch.await(timeout, timeUnit);
            return conditionMet || condition.checkCondition();
            {
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        finally {
            pollingTask.cancel(true);
        }
    }

    public static interface WaitCondition {
        public boolean checkCondition();
    }
}

