/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.client.ClientUtil;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarLog;
import net.lightbody.bmp.core.har.HarNameVersion;
import net.lightbody.bmp.core.har.HarPage;
import net.lightbody.bmp.core.util.ThreadUtils;
import net.lightbody.bmp.exception.JettyException;
import net.lightbody.bmp.exception.NameResolutionException;
import net.lightbody.bmp.filters.RequestFilter;
import net.lightbody.bmp.filters.ResponseFilter;
import net.lightbody.bmp.proxy.BlacklistEntry;
import net.lightbody.bmp.proxy.BrowserMobProxyHandler;
import net.lightbody.bmp.proxy.CaptureType;
import net.lightbody.bmp.proxy.LegacyProxyServer;
import net.lightbody.bmp.proxy.RewriteRule;
import net.lightbody.bmp.proxy.auth.AuthType;
import net.lightbody.bmp.proxy.dns.AdvancedHostResolver;
import net.lightbody.bmp.proxy.http.BrowserMobHttpClient;
import net.lightbody.bmp.proxy.http.RequestInterceptor;
import net.lightbody.bmp.proxy.http.ResponseInterceptor;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.SocketListener;
import net.lightbody.bmp.proxy.jetty.jetty.Server;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.java_bandwidthlimiter.StreamManager;
import org.littleshoot.proxy.HttpFiltersSource;
import org.openqa.selenium.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ProxyServer
implements LegacyProxyServer,
BrowserMobProxy {
    private static final HarNameVersion CREATOR = new HarNameVersion("BrowserMob Proxy", "2.1.0-beta-2-legacy");
    private static final Logger LOG = LoggerFactory.getLogger(ProxyServer.class);
    public static final String ALLOW_NATIVE_DNS_FALLBACK = "bmp.allowNativeDnsFallback";
    private Server server;
    private int port = 0;
    private InetAddress localHost;
    private BrowserMobHttpClient client;
    private StreamManager streamManager;
    private HarPage currentPage;
    private BrowserMobProxyHandler handler;
    private AtomicInteger pageCount = new AtomicInteger(1);
    private AtomicInteger requestCounter = new AtomicInteger(0);
    private boolean started;
    private InetSocketAddress chainedProxyAddress;

    public ProxyServer() {
    }

    public ProxyServer(int port) {
        this.port = port;
    }

    @Override
    public void start() {
        this.streamManager = new StreamManager(100000000L);
        this.server = new Server();
        SocketListener listener = new SocketListener(new InetAddrPort(this.getLocalHost(), this.getPort()));
        this.server.addListener(listener);
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        this.server.addContext(context);
        this.handler = new BrowserMobProxyHandler();
        this.handler.setJettyServer(this.server);
        this.handler.setShutdownLock(new Object());
        this.client = new BrowserMobHttpClient(this.streamManager, this.requestCounter);
        if ("false".equalsIgnoreCase(System.getProperty(ALLOW_NATIVE_DNS_FALLBACK))) {
            this.client.setResolver(ClientUtil.createDnsJavaResolver());
        }
        this.client.prepareForBrowser();
        this.handler.setHttpClient(this.client);
        context.addHandler(this.handler);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new JettyException("Exception occurred when starting the server", e);
        }
        this.setPort(listener.getPort());
        this.started = true;
    }

    @Override
    public void start(int port) {
        this.port = port;
        this.start();
    }

    @Override
    public void start(int port, InetAddress bindAddress) {
        this.setLocalHost(bindAddress);
        this.start(port);
    }

    @Override
    public void start(int port, InetAddress clientBindAddress, InetAddress serverBindAddress) {
        LOG.warn("The legacy ProxyServer implementation does not support a server bind address");
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Proxy seleniumProxy() throws NameResolutionException {
        InetAddress connectableLocalHost;
        Proxy proxy = new Proxy();
        proxy.setProxyType(Proxy.ProxyType.MANUAL);
        try {
            connectableLocalHost = this.getConnectableLocalHost();
        }
        catch (UnknownHostException e) {
            throw new NameResolutionException("Error getting local host when creating seleniumProxy", e);
        }
        String proxyStr = String.format("%s:%d", connectableLocalHost.getCanonicalHostName(), this.getPort());
        proxy.setHttpProxy(proxyStr);
        proxy.setSslProxy(proxyStr);
        return proxy;
    }

    @Override
    public void cleanup() {
        if (this.handler != null) {
            this.handler.cleanup();
        }
    }

    @Override
    public void stop() {
        this.cleanup();
        if (this.client != null) {
            this.client.shutdown();
        }
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (InterruptedException e) {
            throw new JettyException("Exception occurred when stopping the server", e);
        }
    }

    @Override
    public void abort() {
        this.stop();
    }

    @Override
    public InetAddress getClientBindAddress() {
        return this.getLocalHost();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public InetAddress getServerBindAddress() {
        LOG.warn("LegacyProxyServer does not support a server bind address");
        return null;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public InetAddress getLocalHost() {
        if (this.localHost == null) {
            try {
                this.localHost = InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("InetAddress.getByName failed to look up 0.0.0.0", e);
            }
        }
        return this.localHost;
    }

    @Override
    public InetAddress getConnectableLocalHost() throws UnknownHostException {
        if (this.getLocalHost().equals(InetAddress.getByName("0.0.0.0"))) {
            return InetAddress.getLocalHost();
        }
        return this.getLocalHost();
    }

    @Override
    public void setLocalHost(InetAddress localHost) {
        if (localHost.isAnyLocalAddress() || localHost.isLoopbackAddress()) {
            this.localHost = localHost;
        } else {
            NetworkInterface localInterface;
            try {
                localInterface = NetworkInterface.getByInetAddress(localHost);
            }
            catch (SocketException e) {
                throw new IllegalArgumentException("localHost address must be address of a local adapter (attempted to use: " + localHost + ")", e);
            }
            if (localInterface != null) {
                this.localHost = localHost;
            } else {
                throw new IllegalArgumentException("localHost address must be address of a local adapter (attempted to use: " + localHost + ")");
            }
        }
    }

    @Override
    public Har getHar() {
        boolean success = ThreadUtils.pollForCondition(new ThreadUtils.WaitCondition(){

            @Override
            public boolean checkCondition() {
                return ProxyServer.this.requestCounter.get() == 0;
            }
        }, 5L, TimeUnit.SECONDS);
        if (!success) {
            LOG.warn("Waited 5 seconds for requests to cease before returning HAR; giving up!");
        }
        return this.client.getHar();
    }

    @Override
    public Har newHar() {
        return this.newHar(null);
    }

    @Override
    public Har newHar(String initialPageRef) {
        return this.newHar(initialPageRef, null);
    }

    @Override
    public Har newHar(String initialPageRef, String initialPageTitle) {
        this.pageCount.set(0);
        Har oldHar = this.getHar();
        Har har = new Har(new HarLog(CREATOR));
        this.client.setHar(har);
        this.newPage(initialPageRef, initialPageTitle);
        return oldHar;
    }

    @Override
    public void setHarCaptureTypes(Set<CaptureType> captureTypes) {
        this.setCaptureBinaryContent(captureTypes.contains((Object)CaptureType.REQUEST_BINARY_CONTENT) || captureTypes.contains((Object)CaptureType.RESPONSE_BINARY_CONTENT));
        this.setCaptureContent(captureTypes.contains((Object)CaptureType.REQUEST_CONTENT) || captureTypes.contains((Object)CaptureType.RESPONSE_CONTENT));
        this.setCaptureHeaders(captureTypes.contains((Object)CaptureType.REQUEST_HEADERS) || captureTypes.contains((Object)CaptureType.RESPONSE_HEADERS));
    }

    @Override
    public EnumSet<CaptureType> getHarCaptureTypes() {
        EnumSet<CaptureType> captureTypes = CaptureType.getCookieCaptureTypes();
        if (this.client.isCaptureBinaryContent()) {
            captureTypes.addAll(CaptureType.getBinaryContentCaptureTypes());
        }
        if (this.client.isCaptureContent()) {
            captureTypes.addAll(CaptureType.getNonBinaryContentCaptureTypes());
        }
        if (this.client.isCaptureHeaders()) {
            captureTypes.addAll(CaptureType.getHeaderCaptureTypes());
        }
        return captureTypes;
    }

    @Override
    public void enableHarCaptureTypes(Set<CaptureType> captureTypes) {
        if (captureTypes.contains((Object)CaptureType.REQUEST_BINARY_CONTENT) || captureTypes.contains((Object)CaptureType.RESPONSE_BINARY_CONTENT)) {
            this.setCaptureBinaryContent(true);
        }
        if (captureTypes.contains((Object)CaptureType.REQUEST_CONTENT) || captureTypes.contains((Object)CaptureType.RESPONSE_CONTENT)) {
            this.setCaptureContent(true);
        }
        if (captureTypes.contains((Object)CaptureType.REQUEST_HEADERS) || captureTypes.contains((Object)CaptureType.RESPONSE_HEADERS)) {
            this.setCaptureHeaders(true);
        }
    }

    @Override
    public void disableHarCaptureTypes(Set<CaptureType> captureTypes) {
        if (captureTypes.contains((Object)CaptureType.REQUEST_BINARY_CONTENT) || captureTypes.contains((Object)CaptureType.RESPONSE_BINARY_CONTENT)) {
            this.setCaptureBinaryContent(false);
        }
        if (captureTypes.contains((Object)CaptureType.REQUEST_CONTENT) || captureTypes.contains((Object)CaptureType.RESPONSE_CONTENT)) {
            this.setCaptureContent(false);
        }
        if (captureTypes.contains((Object)CaptureType.REQUEST_HEADERS) || captureTypes.contains((Object)CaptureType.RESPONSE_HEADERS)) {
            this.setCaptureHeaders(false);
        }
    }

    @Override
    public Har newPage() {
        return this.newPage(null);
    }

    @Override
    public Har newPage(String pageRef) {
        return this.newPage(pageRef, null);
    }

    @Override
    public Har newPage(String pageRef, String pageTitle) {
        if (pageRef == null) {
            pageRef = "Page " + this.pageCount.get();
        }
        if (pageTitle == null) {
            pageTitle = pageRef;
        }
        this.client.setHarPageRef(pageRef);
        this.currentPage = new HarPage(pageRef, pageTitle);
        this.client.getHar().getLog().addPage(this.currentPage);
        this.pageCount.incrementAndGet();
        return this.client.getHar();
    }

    @Override
    public Har endHar() {
        this.endPage();
        return this.getHar();
    }

    @Override
    public void setReadBandwidthLimit(long bytesPerSecond) {
        this.getStreamManager().setDownstreamKbps(bytesPerSecond / 1024L);
    }

    @Override
    public void setWriteBandwidthLimit(long bytesPerSecond) {
        this.getStreamManager().setUpstreamKbps(bytesPerSecond / 1024L);
    }

    @Override
    public void setLatency(long latency, TimeUnit timeUnit) {
        this.getStreamManager().setLatency(TimeUnit.MILLISECONDS.convert(latency, timeUnit));
    }

    @Override
    public void setConnectTimeout(int connectionTimeout, TimeUnit timeUnit) {
        this.setConnectionTimeout((int)TimeUnit.MILLISECONDS.convert(connectionTimeout, timeUnit));
    }

    @Override
    public void setIdleConnectionTimeout(int idleConnectionTimeout, TimeUnit timeUnit) {
        this.setSocketOperationTimeout((int)TimeUnit.MILLISECONDS.convert(idleConnectionTimeout, timeUnit));
    }

    @Override
    public void setRequestTimeout(int requestTimeout, TimeUnit timeUnit) {
        this.setRequestTimeout((int)TimeUnit.MILLISECONDS.convert(requestTimeout, timeUnit));
    }

    @Override
    public void autoAuthorization(String domain, String username, String password, AuthType authType) {
        if (authType != AuthType.BASIC) {
            throw new UnsupportedOperationException("Legacy ProxyServer implementation does not support non-BASIC authorization");
        }
        this.autoBasicAuthorization(domain, username, password);
    }

    @Override
    public void stopAutoAuthorization(String domain) {
        LOG.warn("Legacy ProxyServer implementation does not support stopping auto authorization");
    }

    @Override
    public void endPage() {
        if (this.currentPage == null) {
            return;
        }
        this.currentPage.getPageTimings().setOnLoad(new Date().getTime() - this.currentPage.getStartedDateTime().getTime());
        this.client.setHarPageRef(null);
        this.currentPage = null;
    }

    @Override
    public void setRetryCount(int count) {
        this.client.setRetryCount(count);
    }

    @Override
    public void addHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void remapHost(String source, String target) {
        if (this.client.getResolver() instanceof AdvancedHostResolver) {
            AdvancedHostResolver advancedHostResolver = this.client.getResolver();
            advancedHostResolver.remapHost(source, target);
        } else {
            LOG.warn("Attempting to remap host, but host resolver is not an AdvancedHostRemapper. Host resolver is: {}", (Object)this.client.getResolver());
        }
    }

    @Override
    @Deprecated
    public void addRequestInterceptor(HttpRequestInterceptor i) {
        this.client.addRequestInterceptor(i);
    }

    @Override
    public void addRequestInterceptor(RequestInterceptor interceptor) {
        this.client.addRequestInterceptor(interceptor);
    }

    @Override
    @Deprecated
    public void addResponseInterceptor(HttpResponseInterceptor i) {
        this.client.addResponseInterceptor(i);
    }

    @Override
    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        this.client.addResponseInterceptor(interceptor);
    }

    @Override
    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    @Override
    @Deprecated
    public void setDownstreamKbps(long downstreamKbps) {
        this.streamManager.setDownstreamKbps(downstreamKbps);
        this.streamManager.enable();
    }

    @Override
    @Deprecated
    public void setUpstreamKbps(long upstreamKbps) {
        this.streamManager.setUpstreamKbps(upstreamKbps);
        this.streamManager.enable();
    }

    @Override
    @Deprecated
    public void setLatency(long latency) {
        this.streamManager.setLatency(latency);
        this.streamManager.enable();
    }

    @Override
    public void setRequestTimeout(int requestTimeout) {
        this.client.setRequestTimeout(requestTimeout);
    }

    @Override
    public void setSocketOperationTimeout(int readTimeout) {
        this.client.setSocketOperationTimeout(readTimeout);
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.client.setConnectionTimeout(connectionTimeout);
    }

    @Override
    public void autoBasicAuthorization(String domain, String username, String password) {
        this.client.autoBasicAuthorization(domain, username, password);
    }

    @Override
    public void rewriteUrl(String match, String replace) {
        this.client.rewriteUrl(match, replace);
    }

    @Override
    public void rewriteUrls(Map<String, String> rewriteRules) {
        for (Map.Entry<String, String> entry : rewriteRules.entrySet()) {
            this.rewriteUrl(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<String, String> getRewriteRules() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (RewriteRule rewriteRule : this.client.getRewriteRules()) {
            builder.put((Object)rewriteRule.getPattern().pattern(), (Object)rewriteRule.getReplace());
        }
        return builder.build();
    }

    @Override
    public void removeRewriteRule(String urlPattern) {
        this.client.removeRewriteRule(urlPattern);
    }

    @Override
    public void clearRewriteRules() {
        this.client.clearRewriteRules();
    }

    @Override
    public void blacklistRequests(String pattern, int responseCode) {
        this.client.blacklistRequests(pattern, responseCode, null);
    }

    @Override
    public void blacklistRequests(String pattern, int responseCode, String method) {
        this.client.blacklistRequests(pattern, responseCode, method);
    }

    @Override
    public void setBlacklist(Collection<BlacklistEntry> blacklist) {
        for (BlacklistEntry entry : blacklist) {
            if (entry.getHttpMethodPatern() == null) {
                this.blacklistRequests(entry.getUrlPattern().pattern(), entry.getStatusCode());
                continue;
            }
            this.blacklistRequests(entry.getUrlPattern().pattern(), entry.getStatusCode(), entry.getHttpMethodPatern().pattern());
        }
    }

    @Override
    public Collection<BlacklistEntry> getBlacklist() {
        return this.getBlacklistedUrls();
    }

    @Override
    @Deprecated
    public List<BlacklistEntry> getBlacklistedRequests() {
        return this.client.getBlacklistedRequests();
    }

    @Override
    public Collection<BlacklistEntry> getBlacklistedUrls() {
        return this.client.getBlacklistedUrls();
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.client.isWhitelistEnabled();
    }

    @Override
    @Deprecated
    public List<Pattern> getWhitelistRequests() {
        return this.client.getWhitelistRequests();
    }

    @Override
    public Collection<String> getWhitelistUrls() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Pattern pattern : this.getWhitelistRequests()) {
            builder.add((Object)pattern.pattern());
        }
        return builder.build();
    }

    @Override
    public int getWhitelistStatusCode() {
        return this.getWhitelistResponseCode();
    }

    @Override
    public int getWhitelistResponseCode() {
        return this.client.getWhitelistResponseCode();
    }

    @Override
    public void clearBlacklist() {
        this.client.clearBlacklist();
    }

    @Override
    public void whitelistRequests(Collection<String> urlPatterns, int statusCode) {
        this.whitelistRequests(urlPatterns.toArray(new String[urlPatterns.size()]), statusCode);
    }

    @Override
    public void addWhitelistPattern(String urlPattern) {
        ArrayList<String> whitelistUrls = new ArrayList<String>(this.getWhitelistUrls());
        whitelistUrls.add(urlPattern);
        this.whitelistRequests(whitelistUrls, this.getWhitelistStatusCode());
    }

    @Override
    public void whitelistRequests(String[] patterns, int responseCode) {
        this.client.whitelistRequests(patterns, responseCode);
    }

    @Override
    public void enableEmptyWhitelist(int responseCode) {
        this.client.whitelistRequests(new String[0], responseCode);
    }

    @Override
    public void disableWhitelist() {
        this.clearWhitelist();
    }

    @Override
    public void clearWhitelist() {
        this.client.clearWhitelist();
    }

    @Override
    public void addHeader(String name, String value) {
        this.client.addHeader(name, value);
    }

    @Override
    public void removeHeader(String name) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : this.getAllHeaders().entrySet()) {
            if (entry.getKey().equals(name)) continue;
            builder.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.client.setAdditionalHeaders((Map<String, String>)builder.build());
    }

    @Override
    public void removeAllHeaders() {
        this.client.setAdditionalHeaders(Collections.emptyMap());
    }

    @Override
    public Map<String, String> getAllHeaders() {
        return this.client.getAdditionalHeaders();
    }

    @Override
    public void setHostNameResolver(AdvancedHostResolver resolver) {
        this.client.setResolver(resolver);
    }

    @Override
    public AdvancedHostResolver getHostNameResolver() {
        return this.client.getResolver();
    }

    @Override
    public boolean waitForQuiescence(long quietPeriod, long timeout, TimeUnit timeUnit) {
        try {
            this.waitForNetworkTrafficToStop(TimeUnit.MILLISECONDS.convert(quietPeriod, timeUnit), TimeUnit.MILLISECONDS.convert(timeout, timeUnit));
            return true;
        }
        catch (TimeoutException timeoutException) {
            return false;
        }
    }

    @Override
    public void setChainedProxy(InetSocketAddress chainedProxyAddress) {
        this.chainedProxyAddress = chainedProxyAddress;
        this.client.setHttpProxy(String.valueOf(chainedProxyAddress.getHostString()) + ":" + chainedProxyAddress.getPort());
    }

    @Override
    public InetSocketAddress getChainedProxy() {
        return this.chainedProxyAddress;
    }

    @Override
    public void setCaptureHeaders(boolean captureHeaders) {
        this.client.setCaptureHeaders(captureHeaders);
    }

    @Override
    public void setCaptureContent(boolean captureContent) {
        this.client.setCaptureContent(captureContent);
    }

    @Override
    public void setCaptureBinaryContent(boolean captureBinaryContent) {
        this.client.setCaptureBinaryContent(captureBinaryContent);
    }

    @Override
    public void clearDNSCache() {
        if (this.client.getResolver() instanceof AdvancedHostResolver) {
            AdvancedHostResolver advancedHostResolver = this.client.getResolver();
            advancedHostResolver.clearDNSCache();
        } else {
            LOG.warn("Attempting to clear DNS cache, but host resolver is not an AdvancedHostRemapper. Host resolver is: {}", (Object)this.client.getResolver());
        }
    }

    @Override
    public void setDNSCacheTimeout(int timeout) {
        if (this.client.getResolver() instanceof AdvancedHostResolver) {
            AdvancedHostResolver advancedHostResolver = this.client.getResolver();
            advancedHostResolver.setNegativeDNSCacheTimeout(timeout, TimeUnit.MILLISECONDS);
            advancedHostResolver.setPositiveDNSCacheTimeout(timeout, TimeUnit.MILLISECONDS);
        } else {
            LOG.warn("Attempting to set DNS cache timeout, but host resolver is not an AdvancedHostRemapper. Host resolver is: {}", (Object)this.client.getResolver());
        }
    }

    @Override
    public void waitForNetworkTrafficToStop(final long quietPeriodInMs, long timeoutInMs) {
        boolean result = ThreadUtils.pollForCondition(new ThreadUtils.WaitCondition(){

            @Override
            public boolean checkCondition() {
                Date lastCompleted = null;
                Har har = ProxyServer.this.client.getHar();
                if (har == null || har.getLog() == null) {
                    return true;
                }
                for (HarEntry entry : har.getLog().getEntries()) {
                    if (entry.getResponse().getStatus() < 0) {
                        return false;
                    }
                    Date end = new Date(entry.getStartedDateTime().getTime() + entry.getTime());
                    if (lastCompleted == null) {
                        lastCompleted = end;
                        continue;
                    }
                    if (!end.after(lastCompleted)) continue;
                    lastCompleted = end;
                }
                return lastCompleted != null && System.currentTimeMillis() - lastCompleted.getTime() >= quietPeriodInMs;
            }
        }, timeoutInMs, TimeUnit.MILLISECONDS);
        if (!result) {
            throw new TimeoutException("Timed out after " + timeoutInMs + " ms while waiting for network traffic to stop");
        }
    }

    @Override
    public void setOptions(Map<String, String> options) {
        if (options.containsKey("httpProxy")) {
            this.client.setHttpProxy(options.get("httpProxy"));
        }
    }

    @Override
    public void addFirstHttpFilterFactory(HttpFiltersSource filterFactory) {
        LOG.warn("The legacy ProxyServer implementation does not support HTTP filter factories. Use addRequestInterceptor/addResponseInterceptor instead.");
    }

    @Override
    public void addLastHttpFilterFactory(HttpFiltersSource filterFactory) {
        LOG.warn("The legacy ProxyServer implementation does not support HTTP filter factories. Use addRequestInterceptor/addResponseInterceptor instead.");
    }

    @Override
    public void addResponseFilter(ResponseFilter filter) {
        LOG.warn("The legacy ProxyServer implementation does not support addRequestFilter and addResponseFilter. Use addRequestInterceptor/addResponseInterceptor instead.");
    }

    @Override
    public void addRequestFilter(RequestFilter filter) {
        LOG.warn("The legacy ProxyServer implementation does not support addRequestFilter and addResponseFilter. Use addRequestInterceptor/addResponseInterceptor instead.");
    }

    @Override
    public void setMitmDisabled(boolean mitmDisabled) {
        LOG.warn("The legacy ProxyServer implementation does not support disabling MITM.");
    }

    public void cleanSslCertificates() {
        this.handler.cleanSslWithCyberVilliansCA();
    }

    public static class TimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = -7179322468198775663L;

        public TimeoutException(String message) {
            super(message);
        }
    }
}

