/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import net.lightbody.bmp.proxy.http.SimulatedSocket;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.java_bandwidthlimiter.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatedSocketFactory
implements ConnectionSocketFactory {
    private static final int DEFAULT_SOCKET_TIMEOUT = 2000;
    private static Logger LOG = LoggerFactory.getLogger(SimulatedSocketFactory.class);
    private StreamManager streamManager;
    private static Method getHostMethod;

    static {
        try {
            getHostMethod = InetSocketAddress.class.getDeclaredMethod("getHostString", new Class[0]);
            if (!Modifier.isPublic(getHostMethod.getModifiers())) {
                getHostMethod = null;
            }
        }
        catch (Exception exception) {}
        if (getHostMethod == null) {
            try {
                getHostMethod = InetSocketAddress.class.getDeclaredMethod("getHostName", new Class[0]);
                LOG.warn("Using InetSocketAddress.getHostName() rather than InetSocketAddress.getHostString(). Consider upgrading to Java 7 for faster performance!");
            }
            catch (NoSuchMethodException e) {
                String msg = "Something is wrong inside SimulatedSocketFactory and I don't know why!";
                LOG.error(msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
        getHostMethod.setAccessible(true);
    }

    public SimulatedSocketFactory(StreamManager streamManager) {
        assert (streamManager != null);
        this.streamManager = streamManager;
    }

    public static <T extends Socket> void configure(T sock) {
        try {
            sock.setReuseAddress(true);
            sock.setSoLinger(true, 0);
        }
        catch (Exception exception) {}
    }

    public Socket createSocket(HttpContext context) throws IOException {
        SimulatedSocket newSocket = new SimulatedSocket(this.streamManager);
        SimulatedSocketFactory.configure(newSocket);
        return newSocket;
    }

    private String resolveHostName(InetSocketAddress remoteAddress) {
        String hostString = null;
        try {
            hostString = (String)getHostMethod.invoke((Object)remoteAddress, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Expecting InetSocketAddress to have a package scoped \"getHostString\" method which returns a String and takes no input");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Expecting InetSocketAddress to have a package scoped \"getHostString\" method which returns a String and takes no input");
        }
        return hostString;
    }

    public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        if (remoteAddress == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (sock == null) {
            sock = this.createSocket(context);
        }
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        String hostName = this.resolveHostName(remoteAddress);
        InetSocketAddress remoteAddr = remoteAddress;
        if (host != null) {
            remoteAddr = new InetSocketAddress(hostName, remoteAddress.getPort());
        }
        try {
            sock.connect(remoteAddr, connectTimeout);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress + " timed out");
        }
        return sock;
    }

    public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException {
        return this.connectSocket(2000, sock, null, remoteAddress, localAddress, (HttpContext)new BasicHttpContext());
    }
}

