/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import net.lightbody.bmp.proxy.http.AllowAllHostnameVerifier;
import net.lightbody.bmp.proxy.http.RequestInfo;
import net.lightbody.bmp.proxy.http.SimulatedSocket;
import net.lightbody.bmp.proxy.http.SimulatedSocketFactory;
import net.lightbody.bmp.proxy.util.TrustEverythingSSLTrustManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.protocol.HttpContext;
import org.java_bandwidthlimiter.StreamManager;

public class TrustingSSLSocketFactory
extends SSLConnectionSocketFactory {
    private static SSLContext sslContext = SSLContexts.createDefault();
    private StreamManager streamManager;

    static {
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslContext.init(null, new TrustManager[]{new TrustEverythingSSLTrustManager()}, null);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected key management error", e);
        }
    }

    public TrustingSSLSocketFactory(StreamManager streamManager) {
        this(new AllowAllHostnameVerifier(), streamManager);
    }

    public TrustingSSLSocketFactory(X509HostnameVerifier hostnameVerifier, StreamManager streamManager) {
        super(sslContext, hostnameVerifier);
        assert (streamManager != null);
        this.streamManager = streamManager;
    }

    public Socket createSocket(HttpContext context) throws IOException {
        SimulatedSocket newSocket = new SimulatedSocket(this.streamManager);
        SimulatedSocketFactory.configure(newSocket);
        return newSocket;
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        SSLSocket sslSocket = (SSLSocket)super.createLayeredSocket(socket, target, port, context);
        return sslSocket;
    }

    protected void prepareSocket(SSLSocket socket) throws IOException {
        final RequestInfo currentThreadRequestInfo = RequestInfo.get();
        socket.addHandshakeCompletedListener(new HandshakeCompletedListener(){
            private final long handshakeStart = System.nanoTime();

            @Override
            public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                currentThreadRequestInfo.ssl(this.handshakeStart, System.nanoTime());
            }
        });
    }

    public static enum SSLAlgorithm {
        SSLv3,
        TLSv1;

    }
}

