/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import net.lightbody.bmp.proxy.jetty.http.HttpConnection;
import net.lightbody.bmp.proxy.jetty.http.HttpException;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.SocketListener;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletSSL;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;
import net.lightbody.bmp.proxy.jetty.util.Password;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import org.apache.commons.logging.Log;

public class SslListener
extends SocketListener {
    private static Log log = LogFactory.getLog(SslListener.class);
    private String[] cipherSuites = null;
    public static final String DEFAULT_KEYSTORE = String.valueOf(System.getProperty("user.home")) + File.separator + ".keystore";
    public static final String PASSWORD_PROPERTY = "jetty.ssl.password";
    public static final String KEYPASSWORD_PROPERTY = "jetty.ssl.keypassword";
    static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    private String _keystore = DEFAULT_KEYSTORE;
    private transient Password _password;
    private transient Password _keypassword;
    private boolean _needClientAuth = false;
    private boolean _wantClientAuth = false;
    private String _protocol = "TLS";
    private String _algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    private String _keystoreType = "JKS";
    private String _provider = null;

    public SslListener() {
        this.setDefaultScheme("https");
    }

    public SslListener(InetAddrPort p_address) {
        super(p_address);
        if (p_address.getPort() == 0) {
            p_address.setPort(443);
            this.setPort(443);
        }
        this.setDefaultScheme("https");
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setPassword(String password) {
        this._password = Password.getPassword(PASSWORD_PROPERTY, password, null);
    }

    public void setKeyPassword(String password) {
        this._keypassword = Password.getPassword(KEYPASSWORD_PROPERTY, password, null);
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setKeystore(String keystore) {
        this._keystore = keystore;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public String getKeystoreType() {
        return this._keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this._keystoreType = keystoreType;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this._needClientAuth = needClientAuth;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this._wantClientAuth = wantClientAuth;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    @Override
    public boolean isIntegral(HttpConnection connection) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == this.getPort();
    }

    @Override
    public boolean isConfidential(HttpConnection connection) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == this.getPort();
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        SSLContext context = this._provider == null ? SSLContext.getInstance(this._protocol) : SSLContext.getInstance(this._protocol, this._provider);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._algorithm);
        KeyStore keyStore = KeyStore.getInstance(this._keystoreType);
        keyStore.load(Resource.newResource(this._keystore).getInputStream(), this._password.toString().toCharArray());
        keyManagerFactory.init(keyStore, this._keypassword.toString().toCharArray());
        context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        return context.getServerSocketFactory();
    }

    @Override
    protected ServerSocket newServerSocket(InetAddrPort p_address, int p_acceptQueueSize) throws IOException {
        SSLServerSocketFactory factory = null;
        SSLServerSocket socket = null;
        try {
            factory = this.createFactory();
            socket = p_address == null ? (SSLServerSocket)factory.createServerSocket(0, p_acceptQueueSize) : (SSLServerSocket)factory.createServerSocket(p_address.getPort(), p_acceptQueueSize, p_address.getInetAddress());
            if (this._needClientAuth) {
                socket.setNeedClientAuth(true);
            } else if (this._wantClientAuth) {
                socket.setWantClientAuth(true);
            }
            if (this.cipherSuites != null && this.cipherSuites.length > 0) {
                socket.setEnabledCipherSuites(this.cipherSuites);
                int i = 0;
                while (i < this.cipherSuites.length) {
                    log.debug((Object)("SslListener enabled ciphersuite: " + this.cipherSuites[i]));
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            throw new IOException("Could not create JsseListener: " + e.toString());
        }
        return socket;
    }

    protected Socket accept(ServerSocket p_serverSocket) throws IOException {
        try {
            SSLSocket s = (SSLSocket)p_serverSocket.accept();
            if (this.getMaxIdleTimeMs() > 0) {
                s.setSoTimeout(this.getMaxIdleTimeMs());
            }
            s.startHandshake();
            return s;
        }
        catch (SSLException e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void customizeRequest(Socket socket, HttpRequest request) {
        super.customizeRequest(socket, request);
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        try {
            java.security.cert.X509Certificate[] certs;
            Integer keySize;
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession sslSession = sslSocket.getSession();
            String cipherSuite = sslSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sslSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                keySize = cachedInfo.getKeySize();
                certs = cachedInfo.getCerts();
            } else {
                keySize = new Integer(ServletSSL.deduceKeyLength(cipherSuite));
                certs = SslListener.getCertChain(sslSession);
                cachedInfo = new CachedInfo(keySize, certs);
                sslSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
            } else if (this._needClientAuth) {
                throw new HttpException(403);
            }
            request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", keySize);
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sslSession) {
        X509Certificate[] javaxCerts;
        block5: {
            javaxCerts = sslSession.getPeerCertificateChain();
            if (javaxCerts != null && javaxCerts.length != 0) break block5;
            return null;
        }
        try {
            int length = javaxCerts.length;
            java.security.cert.X509Certificate[] javaCerts = new java.security.cert.X509Certificate[length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            int i = 0;
            while (i < length) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
                ++i;
            }
            return javaCerts;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return null;
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            return null;
        }
    }

    public String getProvider() {
        return this._provider;
    }

    public void setProvider(String _provider) {
        this._provider = _provider;
    }

    private class CachedInfo {
        private Integer _keySize;
        private java.security.cert.X509Certificate[] _certs;

        CachedInfo(Integer keySize, java.security.cert.X509Certificate[] certs) {
            this._keySize = keySize;
            this._certs = certs;
        }

        Integer getKeySize() {
            return this._keySize;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this._certs;
        }
    }
}

