/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http.ajp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.ByteArrayISO8859Writer;
import net.lightbody.bmp.proxy.jetty.util.ByteArrayPool;
import net.lightbody.bmp.proxy.jetty.util.LogSupport;
import net.lightbody.bmp.proxy.jetty.util.StringUtil;
import org.apache.commons.logging.Log;

public abstract class AJP13Packet {
    private static Log log = LogFactory.getLog(AJP13Packet.class);
    public static final int __MAX_BUF = 8192;
    public static final int __HDR_SIZE = 4;
    public static final int __DATA_HDR = 7;
    public static final int __MAX_DATA = 8185;
    public static final byte __FORWARD_REQUEST = 2;
    public static final byte __SHUTDOWN = 7;
    public static final byte __SEND_BODY_CHUNK = 3;
    public static final byte __SEND_HEADERS = 4;
    public static final byte __END_RESPONSE = 5;
    public static final byte __GET_BODY_CHUNK = 6;
    public static final String[] __method = new String[]{"ERROR", "OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK", "ACL", "REPORT", "VERSION-CONTROL", "CHECKIN", "CHECKOUT", "UNCHECKOUT", "SEARCH"};
    public String[] __header;
    protected HashMap __headerMap = new HashMap();
    private byte[] _buf;
    private int _bytes;
    private int _pos;
    private ByteArrayISO8859Writer _byteWriter;
    private boolean _ownBuffer;

    public abstract void populateHeaders();

    public AJP13Packet(byte[] buffer, int len) {
        this.populateHeaders();
        this._buf = buffer;
        this._ownBuffer = false;
        this._bytes = len;
    }

    public AJP13Packet(byte[] buffer) {
        this.populateHeaders();
        this._buf = buffer;
        this._ownBuffer = false;
    }

    public AJP13Packet(int size) {
        this.populateHeaders();
        this._buf = ByteArrayPool.getByteArray(size);
        this._ownBuffer = true;
    }

    public void prepare() {
        this._bytes = 0;
        this._pos = 0;
        this.addByte((byte)65);
        this.addByte((byte)66);
        this.addInt(0);
    }

    public void destroy() {
        if (this._ownBuffer) {
            ByteArrayPool.returnByteArray(this._buf);
        }
        this._buf = null;
        this._byteWriter = null;
    }

    public void reset() {
        this._bytes = 0;
        this._pos = 0;
    }

    public byte[] getBuffer() {
        return this._buf;
    }

    public void resetData() {
        this._bytes = 4;
        this._pos = 0;
    }

    public int getMark() {
        return this._bytes;
    }

    public int getBufferSize() {
        return this._buf.length;
    }

    public int unconsumedData() {
        return this._bytes - this._pos;
    }

    public int unconsumedCapacity() {
        return this._buf.length - this._bytes;
    }

    public boolean read(InputStream in) throws IOException {
        this._bytes = 0;
        this._pos = 0;
        do {
            int l;
            if ((l = in.read(this._buf, this._bytes, 4 - this._bytes)) < 0) {
                return false;
            }
            this._bytes += l;
        } while (this._bytes < 4);
        int magic = this.getInt();
        if (magic != 4660) {
            throw new IOException("Bad JSP13 rcv packet:" + magic + " " + this);
        }
        int len = this.getInt();
        int packetLength = 4 + len;
        if (packetLength > this._buf.length) {
            throw new IOException("AJP13 packet (" + packetLength + "bytes) too large for buffer (" + this._buf.length + " bytes)");
        }
        do {
            int l;
            if ((l = in.read(this._buf, this._bytes, packetLength - this._bytes)) < 0) {
                return false;
            }
            this._bytes += l;
        } while (this._bytes < packetLength);
        if (log.isTraceEnabled()) {
            log.trace((Object)("AJP13 rcv: " + this.toString(64)));
        }
        return true;
    }

    public void write(OutputStream out) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("AJP13 snd: " + this.toString(64)));
        }
        out.write(this._buf, 0, this._bytes);
    }

    public byte getByte() {
        return this._buf[this._pos++];
    }

    public int getBytes(byte[] buf, int offset, int length) {
        if (length > this.unconsumedData()) {
            length = this.unconsumedData();
        }
        System.arraycopy(this._buf, this._pos, buf, offset, length);
        this._pos += length;
        return length;
    }

    public boolean getBoolean() {
        return this._buf[this._pos++] != 0;
    }

    public int getInt() {
        int i = this._buf[this._pos++] & 0xFF;
        i = (i << 8) + (this._buf[this._pos++] & 0xFF);
        return i;
    }

    public String getString() {
        int len = this.getInt();
        if (len == 65535) {
            return null;
        }
        try {
            String s = new String(this._buf, this._pos, len, StringUtil.__ISO_8859_1);
            this._pos += len + 1;
            return s;
        }
        catch (IndexOutOfBoundsException e) {
            LogSupport.ignore(log, e);
            return null;
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)e);
            System.exit(1);
            return null;
        }
    }

    public String getMethod() {
        return __method[this.getByte()];
    }

    public String getHeader() {
        if ((0xFF & this._buf[this._pos]) == 160) {
            ++this._pos;
            return this.__header[this._buf[this._pos++]];
        }
        return this.getString();
    }

    public void addByte(byte b) {
        this._buf[this._bytes++] = b;
    }

    public int addBytes(byte[] buf, int offset, int length) {
        if (length > this.unconsumedCapacity()) {
            length = this.unconsumedCapacity();
        }
        System.arraycopy(buf, offset, this._buf, this._bytes, length);
        this._bytes += length;
        return length;
    }

    public void addBoolean(boolean b) {
        this._buf[this._bytes++] = (byte)(b ? 1 : 0);
    }

    public void addInt(int i) {
        this._buf[this._bytes++] = (byte)(i >> 8 & 0xFF);
        this._buf[this._bytes++] = (byte)(i & 0xFF);
    }

    public void setInt(int mark, int i) {
        this._buf[mark] = (byte)(i >> 8 & 0xFF);
        this._buf[mark + 1] = (byte)(i & 0xFF);
    }

    public void addString(String s) throws IOException {
        if (s == null) {
            this.addInt(65535);
            return;
        }
        if (this._byteWriter == null) {
            this._byteWriter = new ByteArrayISO8859Writer(this._buf);
        }
        int p = this._bytes + 2;
        this._byteWriter.setLength(p);
        this._byteWriter.write(s);
        int l = this._byteWriter.size() - p;
        this.addInt(l);
        this._bytes += l;
        this._buf[this._bytes++] = 0;
    }

    public void addHeader(String s) throws IOException {
        Integer h = (Integer)this.__headerMap.get(s);
        if (h != null) {
            this.addInt(h);
        } else {
            this.addString(s);
        }
    }

    public int getDataSize() {
        return this._bytes - 4;
    }

    public void setDataSize() {
        this.setDataSize(this._bytes - 4);
    }

    public void setDataSize(int s) {
        this._bytes = s + 4;
        if (this._buf[4] == 3) {
            ++s;
        }
        this._buf[2] = (byte)(s >> 8 & 0xFF);
        this._buf[3] = (byte)(s & 0xFF);
        if (this._buf[4] == 3) {
            this._buf[5] = (byte)((s -= 4) >> 8 & 0xFF);
            this._buf[6] = (byte)(s & 0xFF);
        }
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int max) {
        StringBuffer b = new StringBuffer();
        StringBuffer a = new StringBuffer();
        b.append(this._bytes);
        b.append('/');
        b.append(this._buf.length);
        b.append('[');
        b.append(this._pos);
        b.append("]: ");
        switch (this._buf[4]) {
            case 2: {
                b.append("FORWARD_REQUEST{:");
                break;
            }
            case 7: {
                b.append("SHUTDOWN        :");
                break;
            }
            case 3: {
                b.append("SEND_BODY_CHUNK :");
                break;
            }
            case 4: {
                b.append("SEND_HEADERS  ( :");
                break;
            }
            case 5: {
                b.append("END_RESPONSE  )}:");
                break;
            }
            case 6: {
                b.append("GET_BODY_CHUNK  :");
            }
        }
        if (max == 0) {
            return b.toString();
        }
        b.append("\n");
        int i = 0;
        while (i < this._bytes) {
            int d = this._buf[i] & 0xFF;
            if (d < 16) {
                b.append('0');
            }
            b.append(Integer.toString(d, 16));
            char c = (char)d;
            if (Character.isLetterOrDigit(c)) {
                a.append(c);
            } else {
                a.append('.');
            }
            if (i % 32 == 31 || i == this._bytes - 1) {
                b.append(" : ");
                b.append(a.toString());
                a.setLength(0);
                b.append("\n");
                if (max > 0 && i + 1 >= max) {
                    break;
                }
            } else {
                b.append(",");
            }
            ++i;
        }
        return b.toString();
    }
}

