/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lightbody.bmp.proxy.jetty.html.Block;
import net.lightbody.bmp.proxy.jetty.html.Break;
import net.lightbody.bmp.proxy.jetty.html.Composite;
import net.lightbody.bmp.proxy.jetty.html.Element;
import net.lightbody.bmp.proxy.jetty.html.Font;
import net.lightbody.bmp.proxy.jetty.html.Form;
import net.lightbody.bmp.proxy.jetty.html.Heading;
import net.lightbody.bmp.proxy.jetty.html.Input;
import net.lightbody.bmp.proxy.jetty.html.Link;
import net.lightbody.bmp.proxy.jetty.html.Page;
import net.lightbody.bmp.proxy.jetty.html.Target;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.HttpException;
import net.lightbody.bmp.proxy.jetty.http.HttpHandler;
import net.lightbody.bmp.proxy.jetty.http.HttpListener;
import net.lightbody.bmp.proxy.jetty.http.HttpServer;
import net.lightbody.bmp.proxy.jetty.http.PathMap;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHandler;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.Container;
import net.lightbody.bmp.proxy.jetty.util.LifeCycle;
import net.lightbody.bmp.proxy.jetty.util.LogSupport;
import net.lightbody.bmp.proxy.jetty.util.URI;
import net.lightbody.bmp.proxy.jetty.util.UrlEncoded;
import org.apache.commons.logging.Log;

public class AdminServlet
extends HttpServlet {
    static Log log = LogFactory.getLog(AdminServlet.class);
    private Collection _servers;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._servers = HttpServer.getHttpServers();
    }

    private String doAction(HttpServletRequest request) throws IOException {
        String action = request.getParameter("A");
        if ("exit all servers".equalsIgnoreCase(action)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        LogSupport.ignore(log, e);
                    }
                    log.info((Object)"Stopping All servers");
                    for (HttpServer server : AdminServlet.this._servers) {
                        try {
                            server.stop();
                        }
                        catch (Exception e) {
                            LogSupport.ignore(log, e);
                        }
                    }
                    log.info((Object)"Exiting JVM");
                    System.exit(1);
                }
            }).start();
            throw new HttpException(503);
        }
        boolean start = "start".equalsIgnoreCase(action);
        String id = request.getParameter("ID");
        StringTokenizer tok = new StringTokenizer(id, ":");
        int tokens = tok.countTokens();
        String target = null;
        try {
            target = tok.nextToken();
            int t = Integer.parseInt(target);
            Iterator s = this._servers.iterator();
            Container server = null;
            while (s.hasNext() && t >= 0) {
                if (t-- == 0) {
                    server = (HttpServer)s.next();
                    continue;
                }
                s.next();
            }
            if (tokens == 1) {
                if (start) {
                    server.start();
                } else {
                    server.stop();
                }
            } else if (tokens == 3) {
                String l = String.valueOf(tok.nextToken()) + ":" + tok.nextToken();
                HttpListener[] listeners = ((HttpServer)server).getListeners();
                int i2 = 0;
                while (i2 < listeners.length) {
                    HttpListener listener = listeners[i2];
                    if (listener.toString().indexOf(l) >= 0) {
                        if (start) {
                            listener.start();
                        } else {
                            listener.stop();
                        }
                    }
                    ++i2;
                }
            } else {
                String host = tok.nextToken();
                if ("null".equals(host)) {
                    host = null;
                }
                String contextPath = tok.nextToken();
                target = String.valueOf(target) + ":" + host + ":" + contextPath;
                if (contextPath.length() > 1) {
                    contextPath = String.valueOf(contextPath) + "/*";
                }
                int contextIndex = Integer.parseInt(tok.nextToken());
                target = String.valueOf(target) + ":" + contextIndex;
                HttpContext context = ((HttpServer)server).getContext(host, contextPath, contextIndex);
                if (tokens == 4) {
                    if (start) {
                        context.start();
                    } else {
                        context.stop();
                    }
                } else if (tokens == 5) {
                    int handlerIndex = Integer.parseInt(tok.nextToken());
                    HttpHandler handler = context.getHandlers()[handlerIndex];
                    if (start) {
                        handler.start();
                    } else {
                        handler.stop();
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        catch (Error e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        return target;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getQueryString() != null && request.getQueryString().length() > 0) {
            String target = this.doAction(request);
            response.sendRedirect(String.valueOf(request.getContextPath()) + request.getServletPath() + (request.getPathInfo() != null ? request.getPathInfo() : "") + (target != null ? "#" + target : ""));
            return;
        }
        Page page = new Page();
        page.title(this.getServletInfo());
        page.addHeader("");
        page.attribute("text", "#000000");
        page.attribute("bgcolor", "#FFFFFF");
        page.attribute("link", "#606CC0");
        page.attribute("vlink", "#606CC0");
        page.attribute("alink", "#606CC0");
        page.add(new Block("b").add(new Font(3, true).add(this.getServletInfo())));
        page.add(Break.rule);
        Form form = new Form(String.valueOf(request.getContextPath()) + request.getServletPath() + "?A=exit");
        form.method("GET");
        form.add(new Input("submit", "A", "Exit All Servers"));
        page.add(form);
        page.add(Break.rule);
        page.add(new Heading(3, (Object)"Components:"));
        net.lightbody.bmp.proxy.jetty.html.List sList = new net.lightbody.bmp.proxy.jetty.html.List("ol");
        page.add(sList);
        int i1 = 0;
        Iterator s = this._servers.iterator();
        while (s.hasNext()) {
            String id1 = "" + i1++;
            HttpServer server = (HttpServer)s.next();
            Composite sItem = sList.newItem();
            sItem.add("<B>HttpServer&nbsp;");
            sItem.add(this.lifeCycle(request, id1, server));
            sItem.add("</B>");
            sItem.add(Break.line);
            sItem.add("<B>Listeners:</B>");
            net.lightbody.bmp.proxy.jetty.html.List lList = new net.lightbody.bmp.proxy.jetty.html.List("ul");
            sItem.add(lList);
            HttpListener[] listeners = server.getListeners();
            int i2 = 0;
            while (i2 < listeners.length) {
                HttpListener listener = listeners[i2];
                String id2 = String.valueOf(id1) + ":" + listener;
                lList.add(this.lifeCycle(request, id2, listener));
                ++i2;
            }
            Map hostMap = server.getHostMap();
            sItem.add("<B>Contexts:</B>");
            net.lightbody.bmp.proxy.jetty.html.List hcList = new net.lightbody.bmp.proxy.jetty.html.List("ul");
            sItem.add(hcList);
            for (Map.Entry hEntry : hostMap.entrySet()) {
                String host = (String)hEntry.getKey();
                PathMap contexts = (PathMap)hEntry.getValue();
                for (Map.Entry cEntry : contexts.entrySet()) {
                    String contextPath = (String)cEntry.getKey();
                    List contextList = (List)cEntry.getValue();
                    Composite hcItem = hcList.newItem();
                    if (host != null) {
                        hcItem.add("Host=" + host + ":");
                    }
                    hcItem.add("ContextPath=" + contextPath);
                    String id3 = String.valueOf(id1) + ":" + host + ":" + (contextPath.length() > 2 ? contextPath.substring(0, contextPath.length() - 2) : contextPath);
                    net.lightbody.bmp.proxy.jetty.html.List cList = new net.lightbody.bmp.proxy.jetty.html.List("ol");
                    hcItem.add(cList);
                    int i4 = 0;
                    while (i4 < contextList.size()) {
                        String id4 = String.valueOf(id3) + ":" + i4;
                        Composite cItem = cList.newItem();
                        HttpContext hc = (HttpContext)contextList.get(i4);
                        cItem.add(this.lifeCycle(request, id4, hc));
                        cItem.add("<BR>ResourceBase=" + hc.getResourceBase());
                        cItem.add("<BR>ClassPath=" + hc.getClassPath());
                        net.lightbody.bmp.proxy.jetty.html.List hList = new net.lightbody.bmp.proxy.jetty.html.List("ol");
                        cItem.add(hList);
                        int handlers = hc.getHandlers().length;
                        int i5 = 0;
                        while (i5 < handlers) {
                            String id5 = String.valueOf(id4) + ":" + i5;
                            HttpHandler handler = hc.getHandlers()[i5];
                            Composite hItem = hList.newItem();
                            hItem.add(this.lifeCycle(request, id5, handler, handler.getName()));
                            if (handler instanceof ServletHandler) {
                                hItem.add("<BR>" + ((ServletHandler)handler).getServletMap());
                            }
                            ++i5;
                        }
                        ++i4;
                    }
                }
            }
            sItem.add("<P>");
        }
        response.setContentType("text/html");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache,no-store");
        PrintWriter writer = response.getWriter();
        page.write(writer);
        ((Writer)writer).flush();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String target = null;
        response.sendRedirect(String.valueOf(request.getContextPath()) + request.getServletPath() + "/" + Long.toString(System.currentTimeMillis(), 36) + (target != null ? "#" + target : ""));
    }

    private Element lifeCycle(HttpServletRequest request, String id, LifeCycle lc) {
        return this.lifeCycle(request, id, lc, lc.toString());
    }

    private Element lifeCycle(HttpServletRequest request, String id, LifeCycle lc, String name) {
        Composite comp = new Composite();
        comp.add(new Target(id));
        Font font = new Font();
        comp.add(font);
        font.color(lc.isStarted() ? "green" : "red");
        font.add(name);
        String action = lc.isStarted() ? "Stop" : "Start";
        comp.add("&nbsp;[");
        comp.add(new Link(String.valueOf(URI.addPaths(request.getContextPath(), request.getServletPath())) + "?T=" + Long.toString(System.currentTimeMillis(), 36) + "&A=" + action + "&ID=" + UrlEncoded.encodeString(id), (Object)action));
        comp.add("]");
        return comp;
    }

    public String getServletInfo() {
        return "HTTP Admin";
    }
}

