/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.util;

import java.util.HashSet;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarLog;
import net.lightbody.bmp.core.har.HarPage;
import net.sf.uadetector.UserAgentStringParser;
import net.sf.uadetector.service.UADetectorServiceFactory;

public class BrowserMobProxyUtil {
    private static volatile UserAgentStringParser parser;
    private static final Object PARSER_INIT_LOCK;

    static {
        PARSER_INIT_LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserAgentStringParser getUserAgentStringParser() {
        if (parser == null) {
            Object object = PARSER_INIT_LOCK;
            synchronized (object) {
                if (parser == null) {
                    parser = UADetectorServiceFactory.getResourceModuleParser();
                }
            }
        }
        return parser;
    }

    public static Har copyHarThroughPageRef(Har har, String pageRef) {
        if (har == null) {
            return null;
        }
        if (har.getLog() == null) {
            return new Har();
        }
        HashSet<String> pageRefsToCopy = new HashSet<String>();
        for (HarPage page : har.getLog().getPages()) {
            pageRefsToCopy.add(page.getId());
            if (pageRef.equals(page.getId())) break;
        }
        HarLog logCopy = new HarLog();
        for (HarEntry entry : har.getLog().getEntries()) {
            if (!pageRefsToCopy.contains(entry.getPageref())) continue;
            logCopy.addEntry(entry);
        }
        for (HarPage page : har.getLog().getPages()) {
            if (!pageRefsToCopy.contains(page.getId())) continue;
            logCopy.addPage(page);
        }
        Har harCopy = new Har();
        harCopy.setLog(logCopy);
        return harCopy;
    }
}

