/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.util;

import com.google.common.net.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.lightbody.bmp.exception.DecompressionException;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserMobHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(BrowserMobHttpUtil.class);
    public static final String UNKNOWN_CONTENT_TYPE = "application/octet-stream";
    public static final Charset DEFAULT_HTTP_CHARSET = StandardCharsets.ISO_8859_1;
    public static final int DECOMPRESS_BUFFER_SIZE = 16192;

    public static long getHeaderSize(HttpHeaders headers) {
        long headersSize = 0L;
        for (Map.Entry header : headers.entries()) {
            headersSize += (long)(((String)header.getKey()).length() + ((String)header.getValue()).length() + 4);
        }
        return headersSize;
    }

    public static byte[] decompressContents(byte[] fullMessage) throws DecompressionException {
        InflaterInputStream gzipReader = null;
        try {
            try {
                int bytesRead;
                gzipReader = new GZIPInputStream(new ByteArrayInputStream(fullMessage));
                ByteArrayOutputStream uncompressed = new ByteArrayOutputStream(fullMessage.length);
                byte[] decompressBuffer = new byte[16192];
                while ((bytesRead = gzipReader.read(decompressBuffer)) > -1) {
                    uncompressed.write(decompressBuffer, 0, bytesRead);
                }
                fullMessage = uncompressed.toByteArray();
            }
            catch (IOException e) {
                throw new DecompressionException("Unable to decompress response", e);
            }
        }
        finally {
            try {
                if (gzipReader != null) {
                    gzipReader.close();
                }
            }
            catch (IOException e) {
                log.warn("Unable to close gzip stream", (Throwable)e);
            }
        }
        return fullMessage;
    }

    public static boolean hasTextualContent(String contentType) {
        return contentType != null && (contentType.startsWith("text/") || contentType.startsWith("application/x-javascript") || contentType.startsWith("application/javascript") || contentType.startsWith("application/json") || contentType.startsWith("application/xml") || contentType.startsWith("application/xhtml+xml"));
    }

    public static byte[] extractReadableBytes(ByteBuf content) {
        byte[] binaryContent = new byte[content.readableBytes()];
        content.markReaderIndex();
        content.readBytes(binaryContent);
        content.resetReaderIndex();
        return binaryContent;
    }

    public static String getContentAsString(byte[] content, String contentTypeHeader, HttpRequest httpRequest) {
        Charset charset = BrowserMobHttpUtil.readCharsetInContentTypeHeader(contentTypeHeader);
        if (charset == null) {
            charset = DEFAULT_HTTP_CHARSET;
            if (httpRequest != null) {
                log.debug("No charset specified; using charset {} to decode contents to/from {}", (Object)charset, (Object)httpRequest.getUri());
            } else {
                log.debug("No charset specified; using charset {} to decode contents", (Object)charset);
            }
        }
        return new String(content, charset);
    }

    public static Charset deriveCharsetFromContentTypeHeader(String contentTypeHeader) {
        Charset charset = BrowserMobHttpUtil.readCharsetInContentTypeHeader(contentTypeHeader);
        if (charset == null) {
            return DEFAULT_HTTP_CHARSET;
        }
        return charset;
    }

    public static Charset readCharsetInContentTypeHeader(String contentTypeHeader) {
        if (contentTypeHeader == null || contentTypeHeader.isEmpty()) {
            return DEFAULT_HTTP_CHARSET;
        }
        ContentType contentTypeCharset = ContentType.parse((String)contentTypeHeader);
        return contentTypeCharset.getCharset();
    }

    public static String getHostFromRequest(HttpRequest httpRequest) {
        String host = null;
        if (BrowserMobHttpUtil.startsWithHttpOrHttps(httpRequest.getUri())) {
            try {
                URI uri = new URI(httpRequest.getUri());
                host = uri.getHost();
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if (host == null || host.isEmpty()) {
            host = BrowserMobHttpUtil.parseHostHeader(httpRequest, false);
        }
        return host;
    }

    public static String getHostAndPortFromRequest(HttpRequest httpRequest) {
        if (BrowserMobHttpUtil.startsWithHttpOrHttps(httpRequest.getUri())) {
            try {
                return BrowserMobHttpUtil.getHostAndPortFromUri(httpRequest.getUri());
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return BrowserMobHttpUtil.parseHostHeader(httpRequest, true);
    }

    public static String getPathFromRequest(HttpRequest httpRequest) {
        if (BrowserMobHttpUtil.startsWithHttpOrHttps(httpRequest.getUri())) {
            try {
                return BrowserMobHttpUtil.getPathFromUri(httpRequest.getUri());
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return httpRequest.getUri();
    }

    public static boolean startsWithHttpOrHttps(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.startsWith("http://") || uri.startsWith("https://");
    }

    public static String getPathFromUri(String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        if (uri.getQuery() != null) {
            return String.valueOf(uri.getPath()) + '?' + uri.getQuery();
        }
        return uri.getPath();
    }

    public static String getHostAndPortFromUri(String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        if (uri.getPort() == -1) {
            return uri.getHost();
        }
        return HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort()).toString();
    }

    public static boolean isRedirect(HttpResponse httpResponse) {
        switch (httpResponse.getStatus().code()) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    private static String parseHostHeader(HttpRequest httpRequest, boolean includePort) {
        List hosts = httpRequest.headers().getAll("Host");
        if (!hosts.isEmpty()) {
            String hostAndPort = (String)hosts.get(0);
            if (includePort) {
                return hostAndPort;
            }
            HostAndPort parsedHostAndPort = HostAndPort.fromString((String)hostAndPort);
            return parsedHostAndPort.getHostText();
        }
        return null;
    }
}

