/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.util;

import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import java.nio.charset.Charset;
import net.lightbody.bmp.util.BrowserMobHttpUtil;
import net.lightbody.bmp.util.HttpObjectUtil;

public class HttpMessageContents {
    private final FullHttpMessage httpMessage;
    private volatile String textContents;
    private volatile byte[] binaryContents;

    public HttpMessageContents(FullHttpMessage httpMessage) {
        this.httpMessage = httpMessage;
    }

    public void setTextContents(String newContents) {
        HttpObjectUtil.replaceTextHttpEntityBody(this.httpMessage, newContents);
        this.textContents = null;
        this.binaryContents = null;
    }

    public void setBinaryContents(byte[] newBinaryContents) {
        HttpObjectUtil.replaceBinaryHttpEntityBody(this.httpMessage, newBinaryContents);
        this.binaryContents = null;
        this.textContents = null;
    }

    public String getTextContents() {
        if (this.textContents == null) {
            this.textContents = HttpObjectUtil.extractHttpEntityBody(this.httpMessage);
        }
        return this.textContents;
    }

    public byte[] getBinaryContents() {
        if (this.binaryContents == null) {
            this.binaryContents = HttpObjectUtil.extractBinaryHttpEntityBody((HttpContent)this.httpMessage);
        }
        return this.binaryContents;
    }

    public String getContentType() {
        String contentTypeHeader = HttpHeaders.getHeader((HttpMessage)this.httpMessage, (String)"Content-Type");
        if (contentTypeHeader == null || contentTypeHeader.isEmpty()) {
            return "application/octet-stream";
        }
        return contentTypeHeader;
    }

    public Charset getCharset() {
        String contentTypeHeader = HttpHeaders.getHeader((HttpMessage)this.httpMessage, (String)"Content-Type");
        return BrowserMobHttpUtil.deriveCharsetFromContentTypeHeader(contentTypeHeader);
    }

    public boolean isText() {
        return BrowserMobHttpUtil.hasTextualContent(this.getContentType());
    }
}

