/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import com.google.common.util.concurrent.Monitor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ActivityMonitor {
    private final AtomicInteger activeRequests = new AtomicInteger(0);
    private final AtomicInteger totalRequests = new AtomicInteger(0);
    private final AtomicLong lastRequestFinishedNanos = new AtomicLong(System.nanoTime());
    private final Monitor monitor = new Monitor();
    private final Monitor.Guard requestNotActive = new Monitor.Guard(this.monitor){

        public boolean isSatisfied() {
            return ActivityMonitor.this.activeRequests.get() == 0;
        }
    };
    private final Monitor.Guard requestActive = new Monitor.Guard(this.monitor){

        public boolean isSatisfied() {
            return ActivityMonitor.this.activeRequests.get() > 0;
        }
    };

    public void requestStarted() {
        int previousCount = this.activeRequests.getAndIncrement();
        this.totalRequests.incrementAndGet();
        if (previousCount == 0) {
            this.monitor.enter();
            this.monitor.leave();
        }
    }

    public void requestFinished() {
        int newCount = this.activeRequests.decrementAndGet();
        this.lastRequestFinishedNanos.set(System.nanoTime());
        if (newCount == 0) {
            this.monitor.enter();
            this.monitor.leave();
        }
    }

    public int getActiveRequests() {
        return this.activeRequests.get();
    }

    public int getTotalRequests() {
        return this.totalRequests.get();
    }

    public boolean waitForQuiescence(long quietPeriod, long timeout, TimeUnit timeUnit) {
        long minRequestFinishTime;
        if (this.activeRequests.get() == 0) {
            if (timeUnit.convert(System.nanoTime() - this.lastRequestFinishedNanos.get(), TimeUnit.NANOSECONDS) >= quietPeriod) {
                return true;
            }
            minRequestFinishTime = this.lastRequestFinishedNanos.get();
        } else {
            minRequestFinishTime = System.nanoTime();
        }
        long waitUntil = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, timeUnit);
        while (minRequestFinishTime + TimeUnit.NANOSECONDS.convert(quietPeriod, timeUnit) <= waitUntil) {
            long maxWaitTimeForActiveRequests = waitUntil - System.nanoTime() - TimeUnit.NANOSECONDS.convert(quietPeriod, timeUnit);
            boolean success = this.monitor.enterWhenUninterruptibly(this.requestNotActive, maxWaitTimeForActiveRequests, TimeUnit.NANOSECONDS);
            if (!success) {
                return false;
            }
            this.monitor.leave();
            long waitForNewRequests = this.lastRequestFinishedNanos.get() - System.nanoTime() + TimeUnit.NANOSECONDS.convert(quietPeriod, timeUnit);
            if (waitForNewRequests < 0L) {
                return true;
            }
            boolean requestsActive = this.monitor.enterWhenUninterruptibly(this.requestActive, waitForNewRequests, TimeUnit.NANOSECONDS);
            if (requestsActive) {
                this.monitor.leave();
                continue;
            }
            return true;
        }
        return false;
    }
}

