/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarLog;
import net.lightbody.bmp.core.har.HarPage;
import net.lightbody.bmp.mitm.exception.UncheckedIOException;
import net.lightbody.bmp.util.ClasspathResourceUtil;
import net.sf.uadetector.UserAgentStringParser;
import net.sf.uadetector.service.UADetectorServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserMobProxyUtil {
    private static final Logger log = LoggerFactory.getLogger(BrowserMobProxyUtil.class);
    private static final String VERSION_CLASSPATH_RESOURCE = "/net/lightbody/bmp/version";
    private static final String UNKNOWN_VERSION_STRING = "UNKNOWN-VERSION";
    private static volatile UserAgentStringParser parser;
    private static final Supplier<String> version;
    private static final Object PARSER_INIT_LOCK;

    static {
        version = Suppliers.memoize((Supplier)new Supplier<String>(){

            public String get() {
                return BrowserMobProxyUtil.readVersionFileOnClasspath();
            }
        });
        PARSER_INIT_LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserAgentStringParser getUserAgentStringParser() {
        if (parser == null) {
            Object object = PARSER_INIT_LOCK;
            synchronized (object) {
                if (parser == null) {
                    parser = UADetectorServiceFactory.getResourceModuleParser();
                }
            }
        }
        return parser;
    }

    public static Har copyHarThroughPageRef(Har har, String pageRef) {
        if (har == null) {
            return null;
        }
        if (har.getLog() == null) {
            return new Har();
        }
        HashSet<String> pageRefsToCopy = new HashSet<String>();
        for (HarPage page : har.getLog().getPages()) {
            pageRefsToCopy.add(page.getId());
            if (pageRef.equals(page.getId())) break;
        }
        HarLog logCopy = new HarLog();
        for (HarEntry entry : har.getLog().getEntries()) {
            if (!pageRefsToCopy.contains(entry.getPageref())) continue;
            logCopy.addEntry(entry);
        }
        for (HarPage page : har.getLog().getPages()) {
            if (!pageRefsToCopy.contains(page.getId())) continue;
            logCopy.addPage(page);
        }
        Har harCopy = new Har();
        harCopy.setLog(logCopy);
        return harCopy;
    }

    public static String getVersionString() {
        return (String)version.get();
    }

    private static String readVersionFileOnClasspath() {
        String versionString;
        try {
            versionString = ClasspathResourceUtil.classpathResourceToString((String)VERSION_CLASSPATH_RESOURCE, (Charset)StandardCharsets.UTF_8);
        }
        catch (UncheckedIOException e) {
            log.debug("Unable to load version from classpath resource: {}", (Object)VERSION_CLASSPATH_RESOURCE, (Object)e);
            return UNKNOWN_VERSION_STRING;
        }
        if (versionString.isEmpty()) {
            log.debug("Version file on classpath was empty or could not be read. Resource: {}", (Object)VERSION_CLASSPATH_RESOURCE);
            return UNKNOWN_VERSION_STRING;
        }
        return versionString;
    }
}

