/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.eot;

import com.google.common.primitives.Bytes;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.mabb.fontverter.io.DataTypeBindingSerializer;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.io.DataTypeSerializerException;
import org.mabb.fontverter.io.LittleEndianOutputStream;

public class EotHeader {
    public static final long VERSION_ONE = 65536L;
    public static final long VERSION_TWO = 131073L;
    public static final long VERSION_THREE = 131074L;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long eotSize = 0L;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long fontDataSize = 0L;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long version = 131073L;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long flags = 0L;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.BYTE_ARRAY, constLength=10)
    byte[] panose = new byte[10];
    @DataTypeProperty(dataType=DataTypeProperty.DataType.BYTE)
    byte charset;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.BYTE)
    byte italic;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long weight = 0L;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int fsType = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int magicNumber = 20556;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long unicodeRange1;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long unicodeRange2;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long unicodeRange3;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long unicodeRange4;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long codePageRange1;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long codePageRange2;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long checkSumAdjustment;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long reserved1 = 0L;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long reserved2 = 0L;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long reserved3 = 0L;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    long reserved4 = 0L;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int padding1 = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int familyNameSize = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.BYTE, isArray=true, arrayLength="familyNameSize")
    Byte[] familyName = new Byte[0];
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int padding2 = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int styleNameSize;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.BYTE, isArray=true, arrayLength="styleNameSize")
    Byte[] styleName = new Byte[0];
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int Padding3 = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int versionNameSize;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.BYTE, isArray=true, arrayLength="versionNameSize")
    Byte[] versionName = new Byte[0];
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int Padding4 = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int fullNameSize = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.BYTE, isArray=true, arrayLength="fullNameSize")
    Byte[] fullName = new Byte[0];
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int padding5 = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int rootStringSize = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.BYTE, isArray=true, arrayLength="rootStringSize")
    Byte[] rootString = new Byte[0];

    public String getFamilyName() {
        return this.headerEntryToString(this.familyName);
    }

    public String getRootName() {
        return this.headerEntryToString(this.rootString);
    }

    public String getFullName() {
        return this.headerEntryToString(this.fullName);
    }

    public String getVersionName() {
        return this.headerEntryToString(this.versionName);
    }

    public String getStyleName() {
        return this.headerEntryToString(this.styleName);
    }

    public byte[] getData() throws DataTypeSerializerException {
        DataTypeBindingSerializer serializer = new DataTypeBindingSerializer();
        return serializer.serialize(this, new LittleEndianOutputStream());
    }

    public boolean isValid() {
        boolean versionMatches = this.version == 65536L || this.version == 131073L || this.version == 131074L;
        return this.magicNumber == 20556 && versionMatches;
    }

    private String headerEntryToString(Byte[] data) {
        byte[] fullName = Bytes.toArray(Arrays.asList(data));
        try {
            return new String(fullName, "UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

