/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype.TtfInstructions.instructions;

import java.io.IOException;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.opentype.TtfInstructions.InstructionStack;
import org.mabb.fontverter.opentype.TtfInstructions.TtfInstructionVisitor;
import org.mabb.fontverter.opentype.TtfInstructions.TtfVirtualMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TtfInstruction {
    protected static final Logger log = LoggerFactory.getLogger(TtfInstruction.class);
    public int code;
    public TtfVirtualMachine vm;

    public abstract int[] getCodeRanges();

    public abstract void read(FontDataInputStream var1) throws IOException;

    public abstract void execute(InstructionStack var1) throws IOException;

    public void accept(TtfInstructionVisitor visitor) throws IOException {
        visitor.visitGeneric(this);
    }

    public boolean doesMatch(int code) {
        int[] range = this.getCodeRanges();
        if (this.getCodeRanges().length == 1) {
            return code == range[0];
        }
        return code >= range[0] && code <= range[1];
    }

    protected static Long boolToUint32(boolean value) {
        Long uIntResult = 0L;
        if (value) {
            uIntResult = 1L;
        }
        return uIntResult;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

