/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.validator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mabb.fontverter.validator.FontValidationException;
import org.mabb.fontverter.validator.ValidateRule;

public abstract class RuleValidator<T> {
    private T toValidate;
    private List<Object> ruleDefinitions = new ArrayList<Object>();
    List<FontValidatorError> errors = new LinkedList<FontValidatorError>();
    private ValidatorErrorType validateLevel = ValidatorErrorType.ERROR;

    public List<FontValidatorError> validate(T toValidate) throws InvocationTargetException, IllegalAccessException {
        this.errors.clear();
        this.toValidate = toValidate;
        for (Object ruleOn : this.ruleDefinitions) {
            this.evaluateRuleDefinition(ruleOn);
        }
        return this.errors;
    }

    public void validateWithExceptionsThrown(T toValidate) throws InvocationTargetException, IllegalAccessException, FontValidationException {
        this.toValidate = toValidate;
        List<FontValidatorError> errors = this.validate(this.toValidate);
        String validateMessage = "";
        for (FontValidatorError errorOn : errors) {
            validateMessage = validateMessage + "\n" + errorOn.toString();
        }
        if (errors.size() > 0) {
            throw new FontValidationException("Internal Validator error(s) " + validateMessage);
        }
    }

    public void addRuleDefinition(Object ruleDefinition) {
        this.ruleDefinitions.add(ruleDefinition);
    }

    private void evaluateRuleDefinition(Object ruleOn) throws IllegalAccessException, InvocationTargetException {
        for (Method methodOn : ruleOn.getClass().getDeclaredMethods()) {
            if (!methodOn.isAnnotationPresent(ValidateRule.class)) continue;
            this.evaluateRule(methodOn, ruleOn);
        }
    }

    private void evaluateRule(Method methodOn, Object ruleDef) throws IllegalAccessException, InvocationTargetException {
        ValidateRule annotation = methodOn.getAnnotation(ValidateRule.class);
        if (annotation.type().getValue() > this.validateLevel.getValue()) {
            return;
        }
        Object methodResult = methodOn.invoke(ruleDef, this.toValidate);
        boolean isValid = true;
        String field = "";
        if (methodResult instanceof Boolean) {
            isValid = (Boolean)methodResult;
        }
        if (methodResult instanceof String) {
            field = (String)methodResult;
            isValid = field.isEmpty();
        }
        if (!isValid) {
            String className = ruleDef.getClass().getSimpleName();
            String message = String.format("%s.%s %s \nFIELD VALUE: %s", className, methodOn.getName(), annotation.message(), field);
            this.errors.add(new FontValidatorError(annotation.type(), message));
        }
    }

    public ValidatorErrorType getValidateLevel() {
        return this.validateLevel;
    }

    public void setValidateLevel(ValidatorErrorType validateLevel) {
        this.validateLevel = validateLevel;
    }

    public static class FontValidatorError {
        private final ValidatorErrorType type;
        private final String message;

        public FontValidatorError(ValidatorErrorType type, String message) {
            this.type = type;
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public ValidatorErrorType getType() {
            return this.type;
        }

        public String toString() {
            return "Validate " + (Object)((Object)this.getType()) + ": " + this.getMessage();
        }
    }

    public static enum ValidatorErrorType {
        ERROR(1),
        WARNING(2),
        INFO(3),
        NONE(4);

        private final int value;

        private ValidatorErrorType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

