/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.woff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import org.mabb.fontverter.FontNotSupportedException;
import org.mabb.fontverter.FontProperties;
import org.mabb.fontverter.FontVerter;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.converter.CombinedFontConverter;
import org.mabb.fontverter.converter.FontConverter;
import org.mabb.fontverter.converter.OtfToWoffConverter;
import org.mabb.fontverter.converter.WoffToOtfConverter;
import org.mabb.fontverter.woff.WoffFont;
import org.mabb.fontverter.woff.WoffOutputStream;
import org.mabb.fontverter.woff.WoffParser;
import org.mabb.fontverter.woff.WoffTable;

public class Woff1Font
extends WoffFont {
    static final int WOFF1_HEADER_SIZE = 44;

    @Override
    public WoffTable createTable() {
        return new Woff1Table(new byte[0], "    ");
    }

    @Override
    public void addFontTable(byte[] data, String tag, long checksum) {
        Woff1Table table = new Woff1Table(data, tag);
        table.checksum = checksum;
        this.tables.add(table);
    }

    @Override
    byte[] getRawData() throws IOException {
        this.calculateOffsets();
        return super.getRawData();
    }

    private void calculateOffsets() throws IOException {
        int offset = this.tableDirectoryOffsetStart();
        for (WoffTable table : this.tables) {
            Woff1Table tableOn = (Woff1Table)table;
            tableOn.setOffset(offset);
            offset += tableOn.getCompressedData().length;
        }
    }

    @Override
    public void read(byte[] fontFile) throws IOException {
        WoffParser parser = new WoffParser();
        parser.parse(fontFile, this);
    }

    int tableDirectoryOffsetStart() {
        return this.tables.size() * 20 + 44;
    }

    @Override
    public boolean detectFormat(byte[] fontFile) {
        return FontVerterUtils.bytesStartsWith(fontFile, "wOFF");
    }

    @Override
    public FontProperties getProperties() {
        FontProperties properties = new FontProperties();
        properties.setMimeType("application/font-woff");
        properties.setFileEnding("woff");
        properties.setCssFontFaceFormat("woff");
        return properties;
    }

    @Override
    public FontConverter createConverterForType(FontVerter.FontFormat fontFormat) throws FontNotSupportedException {
        if (fontFormat == FontVerter.FontFormat.OTF) {
            return new WoffToOtfConverter();
        }
        if (fontFormat == FontVerter.FontFormat.WOFF2) {
            return new CombinedFontConverter(new WoffToOtfConverter(), new OtfToWoffConverter.OtfToWoff2Converter());
        }
        throw new FontNotSupportedException("Font conversion not supported");
    }

    public static class Woff1Table
    extends WoffTable {
        static final int WOFF1_TABLE_DIRECTORY_ENTRY_SIZE = 20;
        int offset;
        long checksum;
        String tag;

        public Woff1Table(byte[] table, String tag) {
            super(table);
            this.tag = tag;
        }

        @Override
        public byte[] getCompressedData() throws IOException {
            return this.padTableData(super.getCompressedData());
        }

        @Override
        public String getTag() {
            return this.tag;
        }

        @Override
        protected byte[] compress(byte[] bytes) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DeflaterOutputStream compressStream = new DeflaterOutputStream(out);
            compressStream.write(bytes);
            compressStream.close();
            return out.toByteArray();
        }

        protected void readCompressedData(byte[] readData) throws IOException {
            if (readData.length == this.originalLength) {
                this.tableData = readData;
                return;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InflaterOutputStream compressStream = new InflaterOutputStream(out);
            compressStream.write(readData);
            compressStream.close();
            this.tableData = out.toByteArray();
        }

        @Override
        public byte[] getDirectoryData() throws IOException {
            WoffOutputStream writer = new WoffOutputStream();
            writer.writeString(this.tag);
            writer.writeInt(this.offset);
            writer.writeInt(this.getCompressedData().length - this.paddingAdded);
            writer.writeInt(this.tableData.length);
            writer.writeUnsignedInt((int)this.checksum);
            return writer.toByteArray();
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }
    }
}

