/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.sorting.SortingMethod;

public class Configuration {
    private static final String EMBEDDINGS_DIRECTORY = "embeddings";
    private boolean parallelTesting;
    private boolean runWithJenkins;
    private File reportDirectory;
    private File trendsFile;
    private int trendsLimit;
    private String buildNumber;
    private String projectName;
    private List<Map.Entry<String, String>> classifications = new ArrayList<Map.Entry<String, String>>();
    private Collection<Pattern> tagsToExcludeFromChart = new ArrayList<Pattern>();
    private SortingMethod sortingMethod = SortingMethod.NATURAL;
    private List<String> classificationFiles;

    public Configuration(File reportDirectory, String projectName) {
        this.reportDirectory = reportDirectory;
        this.projectName = projectName;
    }

    public boolean isParallelTesting() {
        return this.parallelTesting;
    }

    public void setParallelTesting(boolean parallelTesting) {
        this.parallelTesting = parallelTesting;
    }

    public boolean isRunWithJenkins() {
        return this.runWithJenkins;
    }

    public void setRunWithJenkins(boolean runWithJenkins) {
        this.runWithJenkins = runWithJenkins;
    }

    public File getReportDirectory() {
        return this.reportDirectory;
    }

    public File getTrendsStatsFile() {
        return this.trendsFile;
    }

    public boolean isTrendsStatsFile() {
        return this.trendsFile != null;
    }

    public void setTrendsStatsFile(File trendsFile) {
        this.setTrends(trendsFile, 0);
    }

    public int getTrendsLimit() {
        return this.trendsLimit;
    }

    public void setTrends(File trendsFile, int trendsLimit) {
        this.trendsFile = trendsFile;
        this.trendsLimit = trendsLimit;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public File getEmbeddingDirectory() {
        return new File(this.getReportDirectory().getAbsolutePath(), "cucumber-html-reports" + File.separatorChar + EMBEDDINGS_DIRECTORY);
    }

    public Collection<Pattern> getTagsToExcludeFromChart() {
        return this.tagsToExcludeFromChart;
    }

    public void setTagsToExcludeFromChart(String ... patterns) {
        for (String pattern : patterns) {
            try {
                this.tagsToExcludeFromChart.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                throw new ValidationException(e);
            }
        }
    }

    public void addClassifications(String name, String value) {
        this.classifications.add(new AbstractMap.SimpleEntry<String, String>(name, value));
    }

    public List<Map.Entry<String, String>> getClassifications() {
        return this.classifications;
    }

    public void setSortingMethod(SortingMethod sortingMethod) {
        this.sortingMethod = sortingMethod;
    }

    public SortingMethod getSortingMethod() {
        return this.sortingMethod;
    }

    public void addClassificationFiles(List<String> classificationFiles) {
        this.classificationFiles = classificationFiles;
    }

    public List<String> getClassificationFiles() {
        return this.classificationFiles;
    }
}

