/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.noderunner.amazon.s3.Bucket;
import net.noderunner.amazon.s3.Headers;
import net.noderunner.amazon.s3.Method;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.util.EncodingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalString {
    private static final String AMAZON_HEADER_PREFIX = "x-amz-";
    private static final String ALTERNATIVE_DATE_HEADER = "x-amz-date";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    private CanonicalString() {
    }

    public static String make(Method method, Bucket bucket, String key, Map<String, String> pathArgs, Headers headers) {
        return CanonicalString.make(method, bucket, key, pathArgs, headers, null);
    }

    public static String make(Method method, Bucket bucket, String key, Map<String, String> pathArgs, Headers headers, String expires) {
        StringBuilder buf = new StringBuilder(128);
        buf.append(method.name()).append("\n");
        TreeMap<String, String> interestingHeaders = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, List<String>> entry : headers.getHeaders().entrySet()) {
                String lk;
                String hashKey = entry.getKey();
                if (hashKey == null || !(lk = hashKey.toLowerCase(Locale.US)).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith(AMAZON_HEADER_PREFIX)) continue;
                interestingHeaders.put(lk, CanonicalString.concatenateList(entry.getValue()));
            }
        }
        if (interestingHeaders.containsKey(ALTERNATIVE_DATE_HEADER)) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (Map.Entry<String, List<String>> entry : interestingHeaders.entrySet()) {
            String headerKey = entry.getKey();
            if (headerKey.startsWith(AMAZON_HEADER_PREFIX)) {
                buf.append(headerKey).append(':').append((String)((Object)entry.getValue()));
            } else {
                buf.append((String)((Object)entry.getValue()));
            }
            buf.append("\n");
        }
        if (bucket != null && bucket.specified()) {
            buf.append("/" + bucket.getName());
        }
        buf.append("/");
        if (key != null) {
            buf.append(key);
        }
        if (pathArgs != null) {
            if (pathArgs.containsKey("acl")) {
                buf.append("?acl");
            } else if (pathArgs.containsKey("torrent")) {
                buf.append("?torrent");
            } else if (pathArgs.containsKey("logging")) {
                buf.append("?logging");
            } else if (pathArgs.containsKey("location")) {
                buf.append("?location");
            }
        }
        return buf.toString();
    }

    private static String concatenateList(List<String> values) {
        StringBuilder buf = new StringBuilder();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            buf.append(values.get(i).replaceAll("\n", "").trim());
            if (i == size - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    static Key key(String awsSecretAccessKey) {
        SecretKeySpec signingKey = new SecretKeySpec(awsSecretAccessKey.getBytes(), HMAC_SHA1_ALGORITHM);
        return signingKey;
    }

    static String encode(Key signingKey, String canonicalString) {
        Mac mac;
        try {
            mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find sha1 algorithm", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not initialize the MAC algorithm", e);
        }
        mac.update(UTF8.encode(canonicalString));
        byte[] encode = Base64.encodeBase64((byte[])mac.doFinal());
        return EncodingUtil.getAsciiString((byte[])encode);
    }
}

