/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3;

import java.io.IOException;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.noderunner.amazon.s3.Bucket;
import net.noderunner.amazon.s3.CallingFormat;
import net.noderunner.amazon.s3.CanonicalString;
import net.noderunner.amazon.s3.GetResponse;
import net.noderunner.amazon.s3.GetStreamResponse;
import net.noderunner.amazon.s3.Headers;
import net.noderunner.amazon.s3.ListAllBucketsResponse;
import net.noderunner.amazon.s3.ListResponse;
import net.noderunner.amazon.s3.LocationResponse;
import net.noderunner.amazon.s3.Method;
import net.noderunner.amazon.s3.Response;
import net.noderunner.amazon.s3.S3Object;
import net.noderunner.amazon.s3.UrlEncoder;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection {
    public static final String LOCATION_DEFAULT = null;
    public static final String LOCATION_EU = "EU";
    public static final String DEFAULT_HOST = "s3.amazonaws.com";
    public static final int INSECURE_PORT = 80;
    public static final int SECURE_PORT = 443;
    public static final int EXPECT_SIZE = 1024;
    private String awsAccessKeyId;
    private Key awsSecretAccessKey;
    private boolean isSecure;
    private String server;
    private int port;
    private CallingFormat callingFormat;
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private HostConfiguration config;
    private HttpClient client;

    public Connection(String awsAccessKeyId, String awsSecretAccessKey) {
        this(awsAccessKeyId, awsSecretAccessKey, true);
    }

    public Connection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, DEFAULT_HOST);
    }

    public Connection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80);
    }

    public Connection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, port, CallingFormat.SUBDOMAIN);
    }

    public Connection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, CallingFormat format) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80, format);
    }

    public Connection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port, CallingFormat format) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretAccessKey = CanonicalString.key(awsSecretAccessKey);
        this.isSecure = isSecure;
        this.server = server;
        this.port = port;
        this.callingFormat = format;
        this.config = new HostConfiguration();
        this.config.setHost(server, port, isSecure ? "http" : "https");
        this.client = new HttpClient((HttpConnectionManager)this.connectionManager);
        this.client.setHostConfiguration(this.config);
    }

    public Response create(Bucket bucket, String location, Headers headers) throws IOException {
        String body;
        if (location == null) {
            body = null;
        } else if (LOCATION_EU.equals(location)) {
            if (!this.callingFormat.supportsLocatedBuckets()) {
                throw new IllegalArgumentException("Creating location-constrained bucket with unsupported calling-format");
            }
            body = "<CreateBucketConstraint><LocationConstraint>" + location + "</LocationConstraint></CreateBucketConstraint>";
        } else {
            throw new IllegalArgumentException("Invalid Location: " + location);
        }
        if (!bucket.validateName(this.callingFormat)) {
            throw new IllegalArgumentException("Invalid Bucket Name: " + bucket);
        }
        PutMethod method = (PutMethod)this.makeRequest(Method.PUT, bucket, headers);
        if (body != null) {
            StringRequestEntity sre = new StringRequestEntity(body, "text/xml", "UTF-8");
            method.setRequestEntity((RequestEntity)sre);
        }
        this.executeRelease((HttpMethod)method);
        return new Response((HttpMethod)method);
    }

    private int execute(HttpMethod method) throws IOException {
        return this.client.executeMethod(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeRelease(HttpMethod method) throws IOException {
        try {
            int n = this.client.executeMethod(method);
            return n;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response create(Bucket bucket, String location) throws IOException {
        return this.create(bucket, location, null);
    }

    public Response create(Bucket bucket) throws IOException {
        return this.create(bucket, null);
    }

    public boolean exists(Bucket bucket) throws IOException {
        HttpMethod method = this.makeRequest(Method.HEAD, bucket);
        int httpCode = this.executeRelease(method);
        return httpCode >= 200 && httpCode < 300;
    }

    public ListResponse list(Bucket bucket, String prefix, String marker, Integer maxKeys, Headers headers) throws IOException {
        return this.list(bucket, prefix, marker, maxKeys, null, headers);
    }

    public ListResponse list(Bucket bucket, String prefix, String marker, Integer maxKeys) throws IOException {
        return this.list(bucket, prefix, marker, maxKeys, null);
    }

    public ListResponse list(Bucket bucket, Integer maxKeys) throws IOException {
        return this.list(bucket, null, null, maxKeys);
    }

    public ListResponse list(Bucket bucket) throws IOException {
        return this.list(bucket, null, null, null, null);
    }

    public ListResponse list(Bucket bucket, String prefix) throws IOException {
        return this.list(bucket, prefix, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListResponse list(Bucket bucket, String prefix, String marker, Integer maxKeys, String delimiter, Headers headers) throws IOException {
        Map<String, String> pathArgs = Connection.paramsForListOptions(prefix, marker, maxKeys, delimiter);
        HttpMethod method = this.makeRequest(Method.GET, bucket, pathArgs, headers);
        try {
            this.execute(method);
            ListResponse listResponse = new ListResponse(method);
            return listResponse;
        }
        finally {
            method.releaseConnection();
        }
    }

    private static Map<String, String> paramsForListOptions(String prefix, String marker, Integer maxKeys, String delimiter) {
        HashMap<String, String> argParams = new HashMap<String, String>();
        if (prefix != null) {
            argParams.put("prefix", prefix);
        }
        if (marker != null) {
            argParams.put("marker", marker);
        }
        if (delimiter != null) {
            argParams.put("delimiter", delimiter);
        }
        if (maxKeys != null) {
            argParams.put("max-keys", Integer.toString(maxKeys));
        }
        return argParams;
    }

    public Response delete(Bucket bucket, Headers headers) throws IOException {
        HttpMethod method = this.makeRequest(Method.DELETE, bucket, "", null, headers);
        this.executeRelease(method);
        return new Response(method);
    }

    public Response delete(Bucket bucket) throws IOException {
        return this.delete(bucket, (Headers)null);
    }

    public Response put(Bucket bucket, String key, S3Object object, Headers headers) throws IOException {
        PutMethod request = (PutMethod)this.makeRequest(Method.PUT, bucket, key, null, headers, object);
        return this.execute(request, object);
    }

    public Response put(Bucket bucket, String key, S3Object object) throws IOException {
        return this.put(bucket, key, object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResponse get(Bucket bucket, String key, Headers headers) throws IOException {
        HttpMethod method = this.makeRequest(Method.GET, bucket, key, null, headers);
        try {
            this.execute(method);
            GetResponse getResponse = new GetResponse(method);
            return getResponse;
        }
        finally {
            method.releaseConnection();
        }
    }

    public GetResponse get(Bucket bucket, String key) throws IOException {
        return this.get(bucket, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetStreamResponse getStream(Bucket bucket, String key, Headers headers) throws IOException {
        HttpMethod method = this.makeRequest(Method.GET, bucket, key, null, headers);
        boolean ok = false;
        try {
            this.execute(method);
            ok = true;
            GetStreamResponse getStreamResponse = new GetStreamResponse((GetMethod)method);
            return getStreamResponse;
        }
        finally {
            if (!ok) {
                method.releaseConnection();
            }
        }
    }

    public GetStreamResponse getStream(Bucket bucket, String key) throws IOException {
        return this.getStream(bucket, key, null);
    }

    public Response head(Bucket bucket, String key) throws IOException {
        return this.head(bucket, key, null);
    }

    public Response head(Bucket bucket, String key, Headers headers) throws IOException {
        HttpMethod method = this.makeRequest(Method.HEAD, bucket, key, null, headers);
        this.executeRelease(method);
        return new Response(method);
    }

    public Response delete(Bucket bucket, String key, Headers headers) throws IOException {
        HttpMethod method = this.makeRequest(Method.DELETE, bucket, key, null, headers);
        this.executeRelease(method);
        return new Response(method);
    }

    public Response delete(Bucket bucket, String key) throws IOException {
        return this.delete(bucket, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResponse getBucketLogging(Bucket bucket, Headers headers) throws IOException {
        Map<String, String> pathArgs = Collections.singletonMap("logging", "");
        HttpMethod method = this.makeRequest(Method.GET, bucket, "", pathArgs, headers);
        try {
            this.execute(method);
            GetResponse getResponse = new GetResponse(method);
            return getResponse;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response putBucketLogging(Bucket bucket, String loggingXMLDoc, Headers headers) throws IOException {
        Map<String, String> pathArgs = Collections.singletonMap("logging", "");
        S3Object object = new S3Object(loggingXMLDoc.getBytes(), null);
        PutMethod request = (PutMethod)this.makeRequest(Method.PUT, bucket, "", pathArgs, headers, object);
        return this.execute(request, object);
    }

    private Response execute(PutMethod request, S3Object object) throws IOException {
        if (object.getLength() > 1024) {
            request.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        }
        request.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(object.getData()));
        this.executeRelease((HttpMethod)request);
        return new Response((HttpMethod)request);
    }

    public GetResponse getACL(Bucket bucket, Headers headers) throws IOException {
        return this.getACL(bucket, "", headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResponse getACL(Bucket bucket, String key, Headers headers) throws IOException {
        if (key == null) {
            key = "";
        }
        Map<String, String> pathArgs = Collections.singletonMap("acl", "");
        HttpMethod method = this.makeRequest(Method.GET, bucket, key, pathArgs, headers);
        try {
            this.execute(method);
            GetResponse getResponse = new GetResponse(method);
            return getResponse;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response putACL(Bucket bucket, String aclXMLDoc, Headers headers) throws IOException {
        return this.putACL(bucket, "", aclXMLDoc, headers);
    }

    public Response putACL(Bucket bucket, String key, String aclXMLDoc, Headers headers) throws IOException {
        S3Object object = new S3Object(aclXMLDoc);
        Map<String, String> pathArgs = Collections.singletonMap("acl", "");
        PutMethod request = (PutMethod)this.makeRequest(Method.PUT, bucket, key, pathArgs, headers, object);
        return this.execute(request, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationResponse getLocation(Bucket bucket) throws IOException {
        Map<String, String> pathArgs = Collections.singletonMap("location", "");
        HttpMethod method = this.makeRequest(Method.GET, bucket, "", pathArgs, null);
        try {
            this.execute(method);
            LocationResponse locationResponse = new LocationResponse(method);
            return locationResponse;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListAllBucketsResponse listAllBuckets(Headers headers) throws IOException {
        HttpMethod method = this.makeRequest(Method.GET, null, "", null, headers);
        try {
            this.execute(method);
            ListAllBucketsResponse listAllBucketsResponse = new ListAllBucketsResponse(method);
            return listAllBucketsResponse;
        }
        finally {
            method.releaseConnection();
        }
    }

    public ListAllBucketsResponse listAllBuckets() throws IOException {
        return this.listAllBuckets(null);
    }

    private HttpMethod makeRequest(Method method, Bucket bucket, String key, Map<String, String> pathArgs, Headers headers) throws IOException {
        return this.makeRequest(method, bucket, key, pathArgs, headers, null);
    }

    private HttpMethod makeRequest(Method method, Bucket bucket) throws IOException {
        return this.makeRequest(method, bucket, null);
    }

    private HttpMethod makeRequest(Method method, Bucket bucket, Headers headers) throws IOException {
        return this.makeRequest(method, bucket, null, headers);
    }

    private HttpMethod makeRequest(Method method, Bucket bucket, Map<String, String> pathArgs, Headers headers) throws IOException {
        return this.makeRequest(method, bucket, "", pathArgs, headers);
    }

    private HttpMethod makeRequest(Method method, Bucket bucket, String key, Map<String, String> pathArgs, Headers headers, S3Object object) throws IOException {
        HttpMethod httpMethod = method.createHttpMethod();
        URI uri = this.callingFormat.getURI(this.isSecure, this.server, this.port, bucket, key, pathArgs);
        httpMethod.setURI(uri);
        this.addHeaders(httpMethod, headers);
        if (object != null) {
            this.addMetadataHeaders(httpMethod, object.getMetadata());
        }
        this.addAuthHeader(httpMethod, method, bucket, key, pathArgs);
        return httpMethod;
    }

    private void addHeaders(HttpMethod httpMethod, Headers headers) {
        this.addHeaders(httpMethod, headers, "");
    }

    private void addMetadataHeaders(HttpMethod httpMethod, Headers metadata) {
        this.addHeaders(httpMethod, metadata, "x-amz-meta-");
    }

    private void addHeaders(HttpMethod httpMethod, Headers headers, String prefix) {
        if (headers != null) {
            for (Map.Entry<String, List<String>> me : headers.getHeaders().entrySet()) {
                String key = me.getKey();
                for (String value : me.getValue()) {
                    httpMethod.addRequestHeader(prefix + key, value);
                }
            }
        }
    }

    private void addAuthHeader(HttpMethod httpMethod, Method method, Bucket bucket, String key, Map<String, String> pathArgs) {
        if (httpMethod.getRequestHeader("Date") == null) {
            httpMethod.setRequestHeader("Date", Connection.httpDate());
        }
        if (httpMethod.getRequestHeader("Content-Type") == null) {
            httpMethod.setRequestHeader("Content-Type", "");
        }
        Headers prop = new Headers(httpMethod.getRequestHeaders());
        String enckey = UrlEncoder.encode(key);
        String canonicalString = CanonicalString.make(method, bucket, enckey, pathArgs, prop);
        String encodedCanonical = CanonicalString.encode(this.awsSecretAccessKey, canonicalString);
        httpMethod.setRequestHeader("Authorization", "AWS " + this.awsAccessKeyId + ":" + encodedCanonical);
    }

    private static String httpDate() {
        String DateFormat2 = "EEE, dd MMM yyyy HH:mm:ss ";
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format.format(new Date()) + "GMT";
    }

    public void shutdown() {
        this.connectionManager.shutdown();
    }

    public String toString() {
        return "Connection id=" + this.awsAccessKeyId + " isSecure=" + this.isSecure + " server=" + this.server + " port=" + this.port + " format=" + this.callingFormat;
    }

    static {
        String charset = URI.getDefaultProtocolCharset();
        if (!charset.equals("UTF-8")) {
            throw new Error("URI charset must be UTF-8: " + charset);
        }
    }
}

