/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3;

import java.io.IOException;
import java.io.InputStream;
import net.noderunner.amazon.s3.Response;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class GetStreamResponse
extends Response {
    private GetMethod method;

    GetStreamResponse(GetMethod method) throws IOException {
        super((HttpMethod)method);
        this.method = method;
    }

    public InputStream getInputStream() throws IOException {
        InputStream body = this.method.getResponseBodyAsStream();
        if (body == null) {
            throw new IllegalStateException("body null");
        }
        return body;
    }

    public long getLength() {
        return this.method.getResponseContentLength();
    }

    public void release() {
        this.method.releaseConnection();
    }

    public String toString() {
        return super.toString() + " method=" + this.method;
    }
}

