/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

/**
 * Contains the contents of an HTTP response message.
 * In RFC 2616 terms, this object represents data found in the
 * <code>Response</code> body.
 */
public class ServerResponse
	extends Response
{

	private final DataPoster dataPoster;

	/**
	 * Constructs a <code>ServerResponseImpl</code> by parts,
	 * with no data poster.
	 */
	public ServerResponse(StatusLine line, MessageHeaders headers)
	{
		this(line, headers, null);
	}

	/**
	 * Constructs a <code>ServerResponseImpl</code> by parts.
	 * @param dataPoster may be null
	 */
	public ServerResponse(StatusLine line, MessageHeaders headers, DataPoster dataPoster)
	{
		super(line, headers);
		this.dataPoster = dataPoster;
	}

	/**
	 * Constructs a <code>ServerResponseImpl</code> by parts.
	 */
	public ServerResponse(StatusLine line, MessageHeader[] headers) {
		this(line, new MessageHeaders(headers));
	}

	public DataPoster getDataPoster() {
		return dataPoster;
	}

	/**
	 * Returns a debug string showing the response information contained
	 * within.
	 */
	public String toString() {
		return super.toString() + " dataPoster=" + dataPoster;
	}

}
